/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CancelJobRunRequest
extends BmcRequest<Void> {
    private String jobRunId;
    private String opcRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"jobRunId", "opcRequestId", "ifMatch"})
    CancelJobRunRequest(String jobRunId, String opcRequestId, String ifMatch) {
        this.jobRunId = jobRunId;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().jobRunId(this.jobRunId).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public String toString() {
        return "CancelJobRunRequest(super=" + super.toString() + ", jobRunId=" + this.getJobRunId() + ", opcRequestId=" + this.getOpcRequestId() + ", ifMatch=" + this.getIfMatch() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CancelJobRunRequest)) {
            return false;
        }
        CancelJobRunRequest other = (CancelJobRunRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$jobRunId = this.getJobRunId();
        String other$jobRunId = other.getJobRunId();
        if (this$jobRunId == null ? other$jobRunId != null : !this$jobRunId.equals(other$jobRunId)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        if (this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId)) {
            return false;
        }
        String this$ifMatch = this.getIfMatch();
        String other$ifMatch = other.getIfMatch();
        return !(this$ifMatch == null ? other$ifMatch != null : !this$ifMatch.equals(other$ifMatch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CancelJobRunRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $jobRunId = this.getJobRunId();
        result = result * 59 + ($jobRunId == null ? 43 : $jobRunId.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        String $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : $ifMatch.hashCode());
        return result;
    }

    public String getJobRunId() {
        return this.jobRunId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<CancelJobRunRequest, Void> {
        private String jobRunId;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CancelJobRunRequest o) {
            this.jobRunId(o.getJobRunId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CancelJobRunRequest build() {
            CancelJobRunRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder jobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public CancelJobRunRequest buildWithoutInvocationCallback() {
            return new CancelJobRunRequest(this.jobRunId, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "CancelJobRunRequest.Builder(jobRunId=" + this.jobRunId + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

