/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.requests.HasContentLength;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import javax.ws.rs.client.Invocation;

public class CreateJobArtifactRequest
extends BmcRequest<InputStream>
implements HasContentLength {
    private String jobId;
    private Long contentLength;
    private InputStream jobArtifact;
    private String opcRequestId;
    private String opcRetryToken;
    private String contentDisposition;

    @InternalSdk
    public InputStream getBody$() {
        return this.jobArtifact;
    }

    @ConstructorProperties(value={"jobId", "contentLength", "jobArtifact", "opcRequestId", "opcRetryToken", "contentDisposition"})
    CreateJobArtifactRequest(String jobId, Long contentLength, InputStream jobArtifact, String opcRequestId, String opcRetryToken, String contentDisposition) {
        this.jobId = jobId;
        this.contentLength = contentLength;
        this.jobArtifact = jobArtifact;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
        this.contentDisposition = contentDisposition;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().jobId(this.jobId).contentLength(this.contentLength).jobArtifact(this.jobArtifact).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).contentDisposition(this.contentDisposition);
    }

    public String toString() {
        return "CreateJobArtifactRequest(super=" + super.toString() + ", jobId=" + this.getJobId() + ", contentLength=" + this.getContentLength() + ", jobArtifact=" + this.getJobArtifact() + ", opcRequestId=" + this.getOpcRequestId() + ", opcRetryToken=" + this.getOpcRetryToken() + ", contentDisposition=" + this.getContentDisposition() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateJobArtifactRequest)) {
            return false;
        }
        CreateJobArtifactRequest other = (CreateJobArtifactRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$contentLength = this.getContentLength();
        Long other$contentLength = other.getContentLength();
        if (this$contentLength == null ? other$contentLength != null : !((Object)this$contentLength).equals(other$contentLength)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        InputStream this$jobArtifact = this.getJobArtifact();
        InputStream other$jobArtifact = other.getJobArtifact();
        if (this$jobArtifact == null ? other$jobArtifact != null : !this$jobArtifact.equals(other$jobArtifact)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        if (this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId)) {
            return false;
        }
        String this$opcRetryToken = this.getOpcRetryToken();
        String other$opcRetryToken = other.getOpcRetryToken();
        if (this$opcRetryToken == null ? other$opcRetryToken != null : !this$opcRetryToken.equals(other$opcRetryToken)) {
            return false;
        }
        String this$contentDisposition = this.getContentDisposition();
        String other$contentDisposition = other.getContentDisposition();
        return !(this$contentDisposition == null ? other$contentDisposition != null : !this$contentDisposition.equals(other$contentDisposition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateJobArtifactRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $contentLength = this.getContentLength();
        result = result * 59 + ($contentLength == null ? 43 : ((Object)$contentLength).hashCode());
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        InputStream $jobArtifact = this.getJobArtifact();
        result = result * 59 + ($jobArtifact == null ? 43 : $jobArtifact.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        String $opcRetryToken = this.getOpcRetryToken();
        result = result * 59 + ($opcRetryToken == null ? 43 : $opcRetryToken.hashCode());
        String $contentDisposition = this.getContentDisposition();
        result = result * 59 + ($contentDisposition == null ? 43 : $contentDisposition.hashCode());
        return result;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public InputStream getJobArtifact() {
        return this.jobArtifact;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateJobArtifactRequest, InputStream> {
        private String jobId;
        private Long contentLength;
        private InputStream jobArtifact;
        private String opcRequestId;
        private String opcRetryToken;
        private String contentDisposition;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateJobArtifactRequest o) {
            this.jobId(o.getJobId());
            this.contentLength(o.getContentLength());
            this.jobArtifact(o.getJobArtifact());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.contentDisposition(o.getContentDisposition());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateJobArtifactRequest build() {
            CreateJobArtifactRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.jobArtifact(body);
            return this;
        }

        Builder() {
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public Builder jobArtifact(InputStream jobArtifact) {
            this.jobArtifact = jobArtifact;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public CreateJobArtifactRequest buildWithoutInvocationCallback() {
            return new CreateJobArtifactRequest(this.jobId, this.contentLength, this.jobArtifact, this.opcRequestId, this.opcRetryToken, this.contentDisposition);
        }

        public String toString() {
            return "CreateJobArtifactRequest.Builder(jobId=" + this.jobId + ", contentLength=" + this.contentLength + ", jobArtifact=" + this.jobArtifact + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ", contentDisposition=" + this.contentDisposition + ")";
        }
    }
}

