/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteJobRequest
extends BmcRequest<Void> {
    private String jobId;
    private String ifMatch;
    private String opcRequestId;
    private Boolean deleteRelatedJobRuns;

    @ConstructorProperties(value={"jobId", "ifMatch", "opcRequestId", "deleteRelatedJobRuns"})
    DeleteJobRequest(String jobId, String ifMatch, String opcRequestId, Boolean deleteRelatedJobRuns) {
        this.jobId = jobId;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
        this.deleteRelatedJobRuns = deleteRelatedJobRuns;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().jobId(this.jobId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).deleteRelatedJobRuns(this.deleteRelatedJobRuns);
    }

    public String toString() {
        return "DeleteJobRequest(super=" + super.toString() + ", jobId=" + this.getJobId() + ", ifMatch=" + this.getIfMatch() + ", opcRequestId=" + this.getOpcRequestId() + ", deleteRelatedJobRuns=" + this.getDeleteRelatedJobRuns() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteJobRequest)) {
            return false;
        }
        DeleteJobRequest other = (DeleteJobRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$deleteRelatedJobRuns = this.getDeleteRelatedJobRuns();
        Boolean other$deleteRelatedJobRuns = other.getDeleteRelatedJobRuns();
        if (this$deleteRelatedJobRuns == null ? other$deleteRelatedJobRuns != null : !((Object)this$deleteRelatedJobRuns).equals(other$deleteRelatedJobRuns)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        String this$ifMatch = this.getIfMatch();
        String other$ifMatch = other.getIfMatch();
        if (this$ifMatch == null ? other$ifMatch != null : !this$ifMatch.equals(other$ifMatch)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteJobRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $deleteRelatedJobRuns = this.getDeleteRelatedJobRuns();
        result = result * 59 + ($deleteRelatedJobRuns == null ? 43 : ((Object)$deleteRelatedJobRuns).hashCode());
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        String $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : $ifMatch.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getDeleteRelatedJobRuns() {
        return this.deleteRelatedJobRuns;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteJobRequest, Void> {
        private String jobId;
        private String ifMatch;
        private String opcRequestId;
        private Boolean deleteRelatedJobRuns;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteJobRequest o) {
            this.jobId(o.getJobId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.deleteRelatedJobRuns(o.getDeleteRelatedJobRuns());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteJobRequest build() {
            DeleteJobRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder deleteRelatedJobRuns(Boolean deleteRelatedJobRuns) {
            this.deleteRelatedJobRuns = deleteRelatedJobRuns;
            return this;
        }

        public DeleteJobRequest buildWithoutInvocationCallback() {
            return new DeleteJobRequest(this.jobId, this.ifMatch, this.opcRequestId, this.deleteRelatedJobRuns);
        }

        public String toString() {
            return "DeleteJobRequest.Builder(jobId=" + this.jobId + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ", deleteRelatedJobRuns=" + this.deleteRelatedJobRuns + ")";
        }
    }
}

