/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.model.Range;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetJobArtifactContentRequest
extends BmcRequest<Void> {
    private String jobId;
    private String opcRequestId;
    private Range range;

    @ConstructorProperties(value={"jobId", "opcRequestId", "range"})
    GetJobArtifactContentRequest(String jobId, String opcRequestId, Range range) {
        this.jobId = jobId;
        this.opcRequestId = opcRequestId;
        this.range = range;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().jobId(this.jobId).opcRequestId(this.opcRequestId).range(this.range);
    }

    public String toString() {
        return "GetJobArtifactContentRequest(super=" + super.toString() + ", jobId=" + this.getJobId() + ", opcRequestId=" + this.getOpcRequestId() + ", range=" + this.getRange() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetJobArtifactContentRequest)) {
            return false;
        }
        GetJobArtifactContentRequest other = (GetJobArtifactContentRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        if (this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId)) {
            return false;
        }
        Range this$range = this.getRange();
        Range other$range = other.getRange();
        return !(this$range == null ? other$range != null : !this$range.equals(other$range));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetJobArtifactContentRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        Range $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : $range.hashCode());
        return result;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Range getRange() {
        return this.range;
    }

    public static class Builder
    implements BmcRequest.Builder<GetJobArtifactContentRequest, Void> {
        private String jobId;
        private String opcRequestId;
        private Range range;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetJobArtifactContentRequest o) {
            this.jobId(o.getJobId());
            this.opcRequestId(o.getOpcRequestId());
            this.range(o.getRange());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetJobArtifactContentRequest build() {
            GetJobArtifactContentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder range(Range range) {
            this.range = range;
            return this;
        }

        public GetJobArtifactContentRequest buildWithoutInvocationCallback() {
            return new GetJobArtifactContentRequest(this.jobId, this.opcRequestId, this.range);
        }

        public String toString() {
            return "GetJobArtifactContentRequest.Builder(jobId=" + this.jobId + ", opcRequestId=" + this.opcRequestId + ", range=" + this.range + ")";
        }
    }
}

