/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetJobRunRequest
extends BmcRequest<Void> {
    private String jobRunId;
    private String opcRequestId;

    @ConstructorProperties(value={"jobRunId", "opcRequestId"})
    GetJobRunRequest(String jobRunId, String opcRequestId) {
        this.jobRunId = jobRunId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().jobRunId(this.jobRunId).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "GetJobRunRequest(super=" + super.toString() + ", jobRunId=" + this.getJobRunId() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetJobRunRequest)) {
            return false;
        }
        GetJobRunRequest other = (GetJobRunRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$jobRunId = this.getJobRunId();
        String other$jobRunId = other.getJobRunId();
        if (this$jobRunId == null ? other$jobRunId != null : !this$jobRunId.equals(other$jobRunId)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetJobRunRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $jobRunId = this.getJobRunId();
        result = result * 59 + ($jobRunId == null ? 43 : $jobRunId.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getJobRunId() {
        return this.jobRunId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetJobRunRequest, Void> {
        private String jobRunId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetJobRunRequest o) {
            this.jobRunId(o.getJobRunId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetJobRunRequest build() {
            GetJobRunRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder jobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetJobRunRequest buildWithoutInvocationCallback() {
            return new GetJobRunRequest(this.jobRunId, this.opcRequestId);
        }

        public String toString() {
            return "GetJobRunRequest.Builder(jobRunId=" + this.jobRunId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

