/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetModelDeploymentRequest
extends BmcRequest<Void> {
    private String modelDeploymentId;
    private String opcRequestId;

    @ConstructorProperties(value={"modelDeploymentId", "opcRequestId"})
    GetModelDeploymentRequest(String modelDeploymentId, String opcRequestId) {
        this.modelDeploymentId = modelDeploymentId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().modelDeploymentId(this.modelDeploymentId).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "GetModelDeploymentRequest(super=" + super.toString() + ", modelDeploymentId=" + this.getModelDeploymentId() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetModelDeploymentRequest)) {
            return false;
        }
        GetModelDeploymentRequest other = (GetModelDeploymentRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$modelDeploymentId = this.getModelDeploymentId();
        String other$modelDeploymentId = other.getModelDeploymentId();
        if (this$modelDeploymentId == null ? other$modelDeploymentId != null : !this$modelDeploymentId.equals(other$modelDeploymentId)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetModelDeploymentRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $modelDeploymentId = this.getModelDeploymentId();
        result = result * 59 + ($modelDeploymentId == null ? 43 : $modelDeploymentId.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getModelDeploymentId() {
        return this.modelDeploymentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetModelDeploymentRequest, Void> {
        private String modelDeploymentId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetModelDeploymentRequest o) {
            this.modelDeploymentId(o.getModelDeploymentId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetModelDeploymentRequest build() {
            GetModelDeploymentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder modelDeploymentId(String modelDeploymentId) {
            this.modelDeploymentId = modelDeploymentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetModelDeploymentRequest buildWithoutInvocationCallback() {
            return new GetModelDeploymentRequest(this.modelDeploymentId, this.opcRequestId);
        }

        public String toString() {
            return "GetModelDeploymentRequest.Builder(modelDeploymentId=" + this.modelDeploymentId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

