/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience;

import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.datascience.DataScience;
import com.oracle.bmc.datascience.DataScienceAsyncClient;
import com.oracle.bmc.datascience.DataSciencePaginators;
import com.oracle.bmc.datascience.DataScienceWaiters;
import com.oracle.bmc.datascience.internal.http.ActivateModelConverter;
import com.oracle.bmc.datascience.internal.http.ActivateModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.ActivateNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.CancelJobRunConverter;
import com.oracle.bmc.datascience.internal.http.CancelWorkRequestConverter;
import com.oracle.bmc.datascience.internal.http.ChangeJobCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.ChangeJobRunCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.ChangeModelCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.ChangeModelDeploymentCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.ChangeNotebookSessionCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.ChangeProjectCompartmentConverter;
import com.oracle.bmc.datascience.internal.http.CreateJobArtifactConverter;
import com.oracle.bmc.datascience.internal.http.CreateJobConverter;
import com.oracle.bmc.datascience.internal.http.CreateJobRunConverter;
import com.oracle.bmc.datascience.internal.http.CreateModelArtifactConverter;
import com.oracle.bmc.datascience.internal.http.CreateModelConverter;
import com.oracle.bmc.datascience.internal.http.CreateModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.CreateModelProvenanceConverter;
import com.oracle.bmc.datascience.internal.http.CreateNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.CreateProjectConverter;
import com.oracle.bmc.datascience.internal.http.DeactivateModelConverter;
import com.oracle.bmc.datascience.internal.http.DeactivateModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.DeactivateNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.DeleteJobConverter;
import com.oracle.bmc.datascience.internal.http.DeleteJobRunConverter;
import com.oracle.bmc.datascience.internal.http.DeleteModelConverter;
import com.oracle.bmc.datascience.internal.http.DeleteModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.DeleteNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.DeleteProjectConverter;
import com.oracle.bmc.datascience.internal.http.GetJobArtifactContentConverter;
import com.oracle.bmc.datascience.internal.http.GetJobConverter;
import com.oracle.bmc.datascience.internal.http.GetJobRunConverter;
import com.oracle.bmc.datascience.internal.http.GetModelArtifactContentConverter;
import com.oracle.bmc.datascience.internal.http.GetModelConverter;
import com.oracle.bmc.datascience.internal.http.GetModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.GetModelProvenanceConverter;
import com.oracle.bmc.datascience.internal.http.GetNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.GetProjectConverter;
import com.oracle.bmc.datascience.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.datascience.internal.http.HeadJobArtifactConverter;
import com.oracle.bmc.datascience.internal.http.HeadModelArtifactConverter;
import com.oracle.bmc.datascience.internal.http.ListFastLaunchJobConfigsConverter;
import com.oracle.bmc.datascience.internal.http.ListJobRunsConverter;
import com.oracle.bmc.datascience.internal.http.ListJobShapesConverter;
import com.oracle.bmc.datascience.internal.http.ListJobsConverter;
import com.oracle.bmc.datascience.internal.http.ListModelDeploymentShapesConverter;
import com.oracle.bmc.datascience.internal.http.ListModelDeploymentsConverter;
import com.oracle.bmc.datascience.internal.http.ListModelsConverter;
import com.oracle.bmc.datascience.internal.http.ListNotebookSessionShapesConverter;
import com.oracle.bmc.datascience.internal.http.ListNotebookSessionsConverter;
import com.oracle.bmc.datascience.internal.http.ListProjectsConverter;
import com.oracle.bmc.datascience.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.datascience.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.datascience.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.datascience.internal.http.UpdateJobConverter;
import com.oracle.bmc.datascience.internal.http.UpdateJobRunConverter;
import com.oracle.bmc.datascience.internal.http.UpdateModelConverter;
import com.oracle.bmc.datascience.internal.http.UpdateModelDeploymentConverter;
import com.oracle.bmc.datascience.internal.http.UpdateModelProvenanceConverter;
import com.oracle.bmc.datascience.internal.http.UpdateNotebookSessionConverter;
import com.oracle.bmc.datascience.internal.http.UpdateProjectConverter;
import com.oracle.bmc.datascience.requests.ActivateModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.ActivateModelRequest;
import com.oracle.bmc.datascience.requests.ActivateNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.CancelJobRunRequest;
import com.oracle.bmc.datascience.requests.CancelWorkRequestRequest;
import com.oracle.bmc.datascience.requests.ChangeJobCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeJobRunCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeModelCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeModelDeploymentCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeNotebookSessionCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeProjectCompartmentRequest;
import com.oracle.bmc.datascience.requests.CreateJobArtifactRequest;
import com.oracle.bmc.datascience.requests.CreateJobRequest;
import com.oracle.bmc.datascience.requests.CreateJobRunRequest;
import com.oracle.bmc.datascience.requests.CreateModelArtifactRequest;
import com.oracle.bmc.datascience.requests.CreateModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.CreateModelProvenanceRequest;
import com.oracle.bmc.datascience.requests.CreateModelRequest;
import com.oracle.bmc.datascience.requests.CreateNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.CreateProjectRequest;
import com.oracle.bmc.datascience.requests.DeactivateModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.DeactivateModelRequest;
import com.oracle.bmc.datascience.requests.DeactivateNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.DeleteJobRequest;
import com.oracle.bmc.datascience.requests.DeleteJobRunRequest;
import com.oracle.bmc.datascience.requests.DeleteModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.DeleteModelRequest;
import com.oracle.bmc.datascience.requests.DeleteNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.DeleteProjectRequest;
import com.oracle.bmc.datascience.requests.GetJobArtifactContentRequest;
import com.oracle.bmc.datascience.requests.GetJobRequest;
import com.oracle.bmc.datascience.requests.GetJobRunRequest;
import com.oracle.bmc.datascience.requests.GetModelArtifactContentRequest;
import com.oracle.bmc.datascience.requests.GetModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.GetModelProvenanceRequest;
import com.oracle.bmc.datascience.requests.GetModelRequest;
import com.oracle.bmc.datascience.requests.GetNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.GetProjectRequest;
import com.oracle.bmc.datascience.requests.GetWorkRequestRequest;
import com.oracle.bmc.datascience.requests.HeadJobArtifactRequest;
import com.oracle.bmc.datascience.requests.HeadModelArtifactRequest;
import com.oracle.bmc.datascience.requests.ListFastLaunchJobConfigsRequest;
import com.oracle.bmc.datascience.requests.ListJobRunsRequest;
import com.oracle.bmc.datascience.requests.ListJobShapesRequest;
import com.oracle.bmc.datascience.requests.ListJobsRequest;
import com.oracle.bmc.datascience.requests.ListModelDeploymentShapesRequest;
import com.oracle.bmc.datascience.requests.ListModelDeploymentsRequest;
import com.oracle.bmc.datascience.requests.ListModelsRequest;
import com.oracle.bmc.datascience.requests.ListNotebookSessionShapesRequest;
import com.oracle.bmc.datascience.requests.ListNotebookSessionsRequest;
import com.oracle.bmc.datascience.requests.ListProjectsRequest;
import com.oracle.bmc.datascience.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.datascience.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.datascience.requests.ListWorkRequestsRequest;
import com.oracle.bmc.datascience.requests.UpdateJobRequest;
import com.oracle.bmc.datascience.requests.UpdateJobRunRequest;
import com.oracle.bmc.datascience.requests.UpdateModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.UpdateModelProvenanceRequest;
import com.oracle.bmc.datascience.requests.UpdateModelRequest;
import com.oracle.bmc.datascience.requests.UpdateNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.UpdateProjectRequest;
import com.oracle.bmc.datascience.responses.ActivateModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.ActivateModelResponse;
import com.oracle.bmc.datascience.responses.ActivateNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.CancelJobRunResponse;
import com.oracle.bmc.datascience.responses.CancelWorkRequestResponse;
import com.oracle.bmc.datascience.responses.ChangeJobCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeJobRunCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeModelCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeModelDeploymentCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeNotebookSessionCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeProjectCompartmentResponse;
import com.oracle.bmc.datascience.responses.CreateJobArtifactResponse;
import com.oracle.bmc.datascience.responses.CreateJobResponse;
import com.oracle.bmc.datascience.responses.CreateJobRunResponse;
import com.oracle.bmc.datascience.responses.CreateModelArtifactResponse;
import com.oracle.bmc.datascience.responses.CreateModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.CreateModelProvenanceResponse;
import com.oracle.bmc.datascience.responses.CreateModelResponse;
import com.oracle.bmc.datascience.responses.CreateNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.CreateProjectResponse;
import com.oracle.bmc.datascience.responses.DeactivateModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.DeactivateModelResponse;
import com.oracle.bmc.datascience.responses.DeactivateNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.DeleteJobResponse;
import com.oracle.bmc.datascience.responses.DeleteJobRunResponse;
import com.oracle.bmc.datascience.responses.DeleteModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.DeleteModelResponse;
import com.oracle.bmc.datascience.responses.DeleteNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.DeleteProjectResponse;
import com.oracle.bmc.datascience.responses.GetJobArtifactContentResponse;
import com.oracle.bmc.datascience.responses.GetJobResponse;
import com.oracle.bmc.datascience.responses.GetJobRunResponse;
import com.oracle.bmc.datascience.responses.GetModelArtifactContentResponse;
import com.oracle.bmc.datascience.responses.GetModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.GetModelProvenanceResponse;
import com.oracle.bmc.datascience.responses.GetModelResponse;
import com.oracle.bmc.datascience.responses.GetNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.GetProjectResponse;
import com.oracle.bmc.datascience.responses.GetWorkRequestResponse;
import com.oracle.bmc.datascience.responses.HeadJobArtifactResponse;
import com.oracle.bmc.datascience.responses.HeadModelArtifactResponse;
import com.oracle.bmc.datascience.responses.ListFastLaunchJobConfigsResponse;
import com.oracle.bmc.datascience.responses.ListJobRunsResponse;
import com.oracle.bmc.datascience.responses.ListJobShapesResponse;
import com.oracle.bmc.datascience.responses.ListJobsResponse;
import com.oracle.bmc.datascience.responses.ListModelDeploymentShapesResponse;
import com.oracle.bmc.datascience.responses.ListModelDeploymentsResponse;
import com.oracle.bmc.datascience.responses.ListModelsResponse;
import com.oracle.bmc.datascience.responses.ListNotebookSessionShapesResponse;
import com.oracle.bmc.datascience.responses.ListNotebookSessionsResponse;
import com.oracle.bmc.datascience.responses.ListProjectsResponse;
import com.oracle.bmc.datascience.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.datascience.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.datascience.responses.ListWorkRequestsResponse;
import com.oracle.bmc.datascience.responses.UpdateJobResponse;
import com.oracle.bmc.datascience.responses.UpdateJobRunResponse;
import com.oracle.bmc.datascience.responses.UpdateModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.UpdateModelProvenanceResponse;
import com.oracle.bmc.datascience.responses.UpdateModelResponse;
import com.oracle.bmc.datascience.responses.UpdateNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.UpdateProjectResponse;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.RetryUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.internal.GuavaUtils;
import com.oracle.bmc.io.internal.KeepOpenInputStream;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.waiter.MaxAttemptsTerminationStrategy;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataScienceClient
implements DataScience {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATASCIENCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://datascience.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private static final Logger LOG = LoggerFactory.getLogger(DataScienceAsyncClient.class);
    private final DataScienceWaiters waiters;
    private final DataSciencePaginators paginators;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;
    private final ApacheConnectionClosingStrategy apacheConnectionClosingStrategy;
    private final RestClientFactory restClientFactory;
    private final RequestSignerFactory defaultRequestSignerFactory;
    private final Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories;
    private final boolean isNonBufferingApacheClient;
    private final ClientConfiguration clientConfigurationToUse;
    private final CircuitBreakerConfiguration circuitBreakerConfiguration;
    private final Object clientUpdate = new Object();
    private volatile RestClient client;
    private volatile String overrideEndpoint = null;

    RestClient getClient() {
        return this.client;
    }

    public DataScienceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DataScienceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DataScienceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DataScienceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DataScienceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DataScienceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DataScienceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public DataScienceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected DataScienceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        this.restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        this.isNonBufferingApacheClient = ApacheUtils.isNonBufferingClientConfigurator((ClientConfigurator)this.restClientFactory.getClientConfigurator());
        this.apacheConnectionClosingStrategy = ApacheUtils.getApacheConnectionClosingStrategy((ClientConfigurator)this.restClientFactory.getClientConfigurator());
        this.clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.defaultRequestSignerFactory = defaultRequestSignerFactory;
        this.signingStrategyRequestSignerFactories = signingStrategyRequestSignerFactories;
        this.retryConfiguration = this.clientConfigurationToUse.getRetryConfiguration();
        CircuitBreakerConfiguration userCircuitBreakerConfiguration = CircuitBreakerUtils.getUserDefinedCircuitBreakerConfiguration((ClientConfiguration)configuration);
        this.circuitBreakerConfiguration = userCircuitBreakerConfiguration == null ? CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION : userCircuitBreakerConfiguration;
        this.refreshClient();
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("DataScience-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DataScienceWaiters(executorService, this);
        this.paginators = new DataSciencePaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshClient() {
        LOG.info("Refreshing client '{}'.", this.client != null ? this.client.getClass() : null);
        RequestSigner defaultRequestSigner = this.defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, this.signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, this.authenticationDetailsProvider));
            }
        }
        RestClient refreshedClient = this.restClientFactory.create(defaultRequestSigner, requestSigners, this.clientConfigurationToUse, this.isNonBufferingApacheClient, null, this.circuitBreakerConfiguration);
        Object object = this.clientUpdate;
        synchronized (object) {
            if (this.overrideEndpoint != null) {
                refreshedClient.setEndpoint(this.overrideEndpoint);
            }
            this.client = refreshedClient;
        }
        LOG.info("Refreshed client '{}'.", this.client != null ? this.client.getClass() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        Object object = this.clientUpdate;
        synchronized (object) {
            this.overrideEndpoint = endpoint;
            this.client.setEndpoint(endpoint);
        }
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        java.util.Optional endpoint = GuavaUtils.adaptFromGuava((Optional)region.getEndpoint(SERVICE));
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ActivateModelResponse activateModel(ActivateModelRequest request) {
        LOG.trace("Called activateModel");
        ActivateModelRequest interceptedRequest = ActivateModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ActivateModelConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ActivateModel", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/ActivateModel");
        Function<Response, ActivateModelResponse> transformer = ActivateModelConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ActivateModelResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ActivateModelResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (ActivateModelResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ActivateModelDeploymentResponse activateModelDeployment(ActivateModelDeploymentRequest request) {
        LOG.trace("Called activateModelDeployment");
        ActivateModelDeploymentRequest interceptedRequest = ActivateModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ActivateModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ActivateModelDeployment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ModelDeployment/ActivateModelDeployment");
        Function<Response, ActivateModelDeploymentResponse> transformer = ActivateModelDeploymentConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ActivateModelDeploymentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ActivateModelDeploymentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (ActivateModelDeploymentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ActivateNotebookSessionResponse activateNotebookSession(ActivateNotebookSessionRequest request) {
        LOG.trace("Called activateNotebookSession");
        ActivateNotebookSessionRequest interceptedRequest = ActivateNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ActivateNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ActivateNotebookSession", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/NotebookSession/ActivateNotebookSession");
        Function<Response, ActivateNotebookSessionResponse> transformer = ActivateNotebookSessionConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ActivateNotebookSessionResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ActivateNotebookSessionResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (ActivateNotebookSessionResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public CancelJobRunResponse cancelJobRun(CancelJobRunRequest request) {
        LOG.trace("Called cancelJobRun");
        CancelJobRunRequest interceptedRequest = CancelJobRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelJobRunConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "CancelJobRun", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/JobRun/CancelJobRun");
        Function<Response, CancelJobRunResponse> transformer = CancelJobRunConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (CancelJobRunResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CancelJobRunResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (CancelJobRunResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        LOG.trace("Called cancelWorkRequest");
        CancelWorkRequestRequest interceptedRequest = CancelWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "CancelWorkRequest", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/WorkRequest/CancelWorkRequest");
        Function<Response, CancelWorkRequestResponse> transformer = CancelWorkRequestConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (CancelWorkRequestResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CancelWorkRequestResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (CancelWorkRequestResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ChangeJobCompartmentResponse changeJobCompartment(ChangeJobCompartmentRequest request) {
        LOG.trace("Called changeJobCompartment");
        ChangeJobCompartmentRequest interceptedRequest = ChangeJobCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeJobCompartmentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ChangeJobCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Job/ChangeJobCompartment");
        Function<Response, ChangeJobCompartmentResponse> transformer = ChangeJobCompartmentConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ChangeJobCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeJobCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeJobCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeJobCompartmentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ChangeJobRunCompartmentResponse changeJobRunCompartment(ChangeJobRunCompartmentRequest request) {
        LOG.trace("Called changeJobRunCompartment");
        ChangeJobRunCompartmentRequest interceptedRequest = ChangeJobRunCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeJobRunCompartmentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ChangeJobRunCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/JobRun/ChangeJobRunCompartment");
        Function<Response, ChangeJobRunCompartmentResponse> transformer = ChangeJobRunCompartmentConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ChangeJobRunCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeJobRunCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeJobRunCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeJobRunCompartmentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ChangeModelCompartmentResponse changeModelCompartment(ChangeModelCompartmentRequest request) {
        LOG.trace("Called changeModelCompartment");
        ChangeModelCompartmentRequest interceptedRequest = ChangeModelCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeModelCompartmentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ChangeModelCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/ChangeModelCompartment");
        Function<Response, ChangeModelCompartmentResponse> transformer = ChangeModelCompartmentConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ChangeModelCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeModelCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeModelCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeModelCompartmentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ChangeModelDeploymentCompartmentResponse changeModelDeploymentCompartment(ChangeModelDeploymentCompartmentRequest request) {
        LOG.trace("Called changeModelDeploymentCompartment");
        ChangeModelDeploymentCompartmentRequest interceptedRequest = ChangeModelDeploymentCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeModelDeploymentCompartmentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ChangeModelDeploymentCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ModelDeployment/ChangeModelDeploymentCompartment");
        Function<Response, ChangeModelDeploymentCompartmentResponse> transformer = ChangeModelDeploymentCompartmentConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ChangeModelDeploymentCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeModelDeploymentCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeModelDeploymentCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeModelDeploymentCompartmentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ChangeNotebookSessionCompartmentResponse changeNotebookSessionCompartment(ChangeNotebookSessionCompartmentRequest request) {
        LOG.trace("Called changeNotebookSessionCompartment");
        ChangeNotebookSessionCompartmentRequest interceptedRequest = ChangeNotebookSessionCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeNotebookSessionCompartmentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ChangeNotebookSessionCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/NotebookSession/ChangeNotebookSessionCompartment");
        Function<Response, ChangeNotebookSessionCompartmentResponse> transformer = ChangeNotebookSessionCompartmentConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ChangeNotebookSessionCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeNotebookSessionCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeNotebookSessionCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeNotebookSessionCompartmentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ChangeProjectCompartmentResponse changeProjectCompartment(ChangeProjectCompartmentRequest request) {
        LOG.trace("Called changeProjectCompartment");
        ChangeProjectCompartmentRequest interceptedRequest = ChangeProjectCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeProjectCompartmentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ChangeProjectCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Project/ChangeProjectCompartment");
        Function<Response, ChangeProjectCompartmentResponse> transformer = ChangeProjectCompartmentConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ChangeProjectCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeProjectCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeProjectCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeProjectCompartmentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public CreateJobResponse createJob(CreateJobRequest request) {
        LOG.trace("Called createJob");
        CreateJobRequest interceptedRequest = CreateJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateJobConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "CreateJob", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Job/CreateJob");
        Function<Response, CreateJobResponse> transformer = CreateJobConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (CreateJobResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateJobResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateJobDetails(), (BmcRequest)retriedRequest);
                return (CreateJobResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateJobArtifactResponse createJobArtifact(CreateJobArtifactRequest request) {
        LOG.trace("Called createJobArtifact");
        try {
            BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)request.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
            if (request.getRetryConfiguration() != null || this.retryConfiguration != null || DataScienceClient.shouldRetryBecauseOfWaiterConfiguration(retrier) || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
                request = (CreateJobArtifactRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)CreateJobArtifactRequest.builder());
            }
            CreateJobArtifactRequest interceptedRequest = CreateJobArtifactConverter.interceptRequest(request);
            WrappedInvocationBuilder ib = CreateJobArtifactConverter.fromRequest(this.client, interceptedRequest);
            ib.property("x-obmcs-internal-signing-strategy-name", (Object)SigningStrategy.EXCLUDE_BODY);
            RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
            RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
            ServiceDetails serviceDetails = new ServiceDetails("DataScience", "CreateJobArtifact", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Job/CreateJobArtifact");
            Function<Response, CreateJobArtifactResponse> transformer = CreateJobArtifactConverter.fromResponse(java.util.Optional.of(serviceDetails));
            CreateJobArtifactResponse createJobArtifactResponse = (CreateJobArtifactResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
                TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
                return (CreateJobArtifactResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                    try {
                        Response response = this.client.post(ib, (Object)retriedRequest.getJobArtifact(), (BmcRequest)retriedRequest);
                        return (CreateJobArtifactResponse)((Object)((Object)((Object)transformer.apply(response))));
                    }
                    catch (RuntimeException e) {
                        if (interceptedRequest.getRetryConfiguration() != null || this.retryConfiguration != null || DataScienceClient.shouldRetryBecauseOfWaiterConfiguration(retrier) || e instanceof BmcException && tokenRefreshRetrier.getRetryCondition().shouldBeRetried((BmcException)e)) {
                            Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getJobArtifact(), (boolean)true);
                        }
                        throw e;
                    }
                })));
            }));
            return createJobArtifactResponse;
        }
        finally {
            KeepOpenInputStream.closeStream((InputStream)request.getJobArtifact());
        }
    }

    @Override
    public CreateJobRunResponse createJobRun(CreateJobRunRequest request) {
        LOG.trace("Called createJobRun");
        CreateJobRunRequest interceptedRequest = CreateJobRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateJobRunConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "CreateJobRun", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/JobRun/CreateJobRun");
        Function<Response, CreateJobRunResponse> transformer = CreateJobRunConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (CreateJobRunResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateJobRunResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateJobRunDetails(), (BmcRequest)retriedRequest);
                return (CreateJobRunResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public CreateModelResponse createModel(CreateModelRequest request) {
        LOG.trace("Called createModel");
        CreateModelRequest interceptedRequest = CreateModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateModelConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "CreateModel", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/CreateModel");
        Function<Response, CreateModelResponse> transformer = CreateModelConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (CreateModelResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateModelResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateModelDetails(), (BmcRequest)retriedRequest);
                return (CreateModelResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateModelArtifactResponse createModelArtifact(CreateModelArtifactRequest request) {
        LOG.trace("Called createModelArtifact");
        try {
            BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)request.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
            if (request.getRetryConfiguration() != null || this.retryConfiguration != null || DataScienceClient.shouldRetryBecauseOfWaiterConfiguration(retrier) || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
                request = (CreateModelArtifactRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)CreateModelArtifactRequest.builder());
            }
            CreateModelArtifactRequest interceptedRequest = CreateModelArtifactConverter.interceptRequest(request);
            WrappedInvocationBuilder ib = CreateModelArtifactConverter.fromRequest(this.client, interceptedRequest);
            ib.property("x-obmcs-internal-signing-strategy-name", (Object)SigningStrategy.EXCLUDE_BODY);
            RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
            RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
            ServiceDetails serviceDetails = new ServiceDetails("DataScience", "CreateModelArtifact", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/CreateModelArtifact");
            Function<Response, CreateModelArtifactResponse> transformer = CreateModelArtifactConverter.fromResponse(java.util.Optional.of(serviceDetails));
            CreateModelArtifactResponse createModelArtifactResponse = (CreateModelArtifactResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
                TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
                return (CreateModelArtifactResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                    try {
                        Response response = this.client.post(ib, (Object)retriedRequest.getModelArtifact(), (BmcRequest)retriedRequest);
                        return (CreateModelArtifactResponse)((Object)((Object)((Object)transformer.apply(response))));
                    }
                    catch (RuntimeException e) {
                        if (interceptedRequest.getRetryConfiguration() != null || this.retryConfiguration != null || DataScienceClient.shouldRetryBecauseOfWaiterConfiguration(retrier) || e instanceof BmcException && tokenRefreshRetrier.getRetryCondition().shouldBeRetried((BmcException)e)) {
                            Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getModelArtifact(), (boolean)true);
                        }
                        throw e;
                    }
                })));
            }));
            return createModelArtifactResponse;
        }
        finally {
            KeepOpenInputStream.closeStream((InputStream)request.getModelArtifact());
        }
    }

    @Override
    public CreateModelDeploymentResponse createModelDeployment(CreateModelDeploymentRequest request) {
        LOG.trace("Called createModelDeployment");
        CreateModelDeploymentRequest interceptedRequest = CreateModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "CreateModelDeployment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ModelDeployment/CreateModelDeployment");
        Function<Response, CreateModelDeploymentResponse> transformer = CreateModelDeploymentConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (CreateModelDeploymentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateModelDeploymentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateModelDeploymentDetails(), (BmcRequest)retriedRequest);
                return (CreateModelDeploymentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public CreateModelProvenanceResponse createModelProvenance(CreateModelProvenanceRequest request) {
        LOG.trace("Called createModelProvenance");
        CreateModelProvenanceRequest interceptedRequest = CreateModelProvenanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateModelProvenanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "CreateModelProvenance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/CreateModelProvenance");
        Function<Response, CreateModelProvenanceResponse> transformer = CreateModelProvenanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (CreateModelProvenanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateModelProvenanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateModelProvenanceDetails(), (BmcRequest)retriedRequest);
                return (CreateModelProvenanceResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public CreateNotebookSessionResponse createNotebookSession(CreateNotebookSessionRequest request) {
        LOG.trace("Called createNotebookSession");
        CreateNotebookSessionRequest interceptedRequest = CreateNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "CreateNotebookSession", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/NotebookSession/CreateNotebookSession");
        Function<Response, CreateNotebookSessionResponse> transformer = CreateNotebookSessionConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (CreateNotebookSessionResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateNotebookSessionResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateNotebookSessionDetails(), (BmcRequest)retriedRequest);
                return (CreateNotebookSessionResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public CreateProjectResponse createProject(CreateProjectRequest request) {
        LOG.trace("Called createProject");
        CreateProjectRequest interceptedRequest = CreateProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateProjectConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "CreateProject", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Project/CreateProject");
        Function<Response, CreateProjectResponse> transformer = CreateProjectConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (CreateProjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateProjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateProjectDetails(), (BmcRequest)retriedRequest);
                return (CreateProjectResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public DeactivateModelResponse deactivateModel(DeactivateModelRequest request) {
        LOG.trace("Called deactivateModel");
        DeactivateModelRequest interceptedRequest = DeactivateModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeactivateModelConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "DeactivateModel", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/DeactivateModel");
        Function<Response, DeactivateModelResponse> transformer = DeactivateModelConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (DeactivateModelResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeactivateModelResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (DeactivateModelResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public DeactivateModelDeploymentResponse deactivateModelDeployment(DeactivateModelDeploymentRequest request) {
        LOG.trace("Called deactivateModelDeployment");
        DeactivateModelDeploymentRequest interceptedRequest = DeactivateModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeactivateModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "DeactivateModelDeployment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ModelDeployment/DeactivateModelDeployment");
        Function<Response, DeactivateModelDeploymentResponse> transformer = DeactivateModelDeploymentConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (DeactivateModelDeploymentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeactivateModelDeploymentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (DeactivateModelDeploymentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public DeactivateNotebookSessionResponse deactivateNotebookSession(DeactivateNotebookSessionRequest request) {
        LOG.trace("Called deactivateNotebookSession");
        DeactivateNotebookSessionRequest interceptedRequest = DeactivateNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeactivateNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "DeactivateNotebookSession", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/NotebookSession/DeactivateNotebookSession");
        Function<Response, DeactivateNotebookSessionResponse> transformer = DeactivateNotebookSessionConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (DeactivateNotebookSessionResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeactivateNotebookSessionResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (DeactivateNotebookSessionResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public DeleteJobResponse deleteJob(DeleteJobRequest request) {
        LOG.trace("Called deleteJob");
        DeleteJobRequest interceptedRequest = DeleteJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteJobConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "DeleteJob", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Job/DeleteJob");
        Function<Response, DeleteJobResponse> transformer = DeleteJobConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (DeleteJobResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteJobResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteJobResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public DeleteJobRunResponse deleteJobRun(DeleteJobRunRequest request) {
        LOG.trace("Called deleteJobRun");
        DeleteJobRunRequest interceptedRequest = DeleteJobRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteJobRunConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "DeleteJobRun", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/JobRun/DeleteJobRun");
        Function<Response, DeleteJobRunResponse> transformer = DeleteJobRunConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (DeleteJobRunResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteJobRunResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteJobRunResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public DeleteModelResponse deleteModel(DeleteModelRequest request) {
        LOG.trace("Called deleteModel");
        DeleteModelRequest interceptedRequest = DeleteModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteModelConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "DeleteModel", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/DeleteModel");
        Function<Response, DeleteModelResponse> transformer = DeleteModelConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (DeleteModelResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteModelResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteModelResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public DeleteModelDeploymentResponse deleteModelDeployment(DeleteModelDeploymentRequest request) {
        LOG.trace("Called deleteModelDeployment");
        DeleteModelDeploymentRequest interceptedRequest = DeleteModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "DeleteModelDeployment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ModelDeployment/DeleteModelDeployment");
        Function<Response, DeleteModelDeploymentResponse> transformer = DeleteModelDeploymentConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (DeleteModelDeploymentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteModelDeploymentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteModelDeploymentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public DeleteNotebookSessionResponse deleteNotebookSession(DeleteNotebookSessionRequest request) {
        LOG.trace("Called deleteNotebookSession");
        DeleteNotebookSessionRequest interceptedRequest = DeleteNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "DeleteNotebookSession", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/NotebookSession/DeleteNotebookSession");
        Function<Response, DeleteNotebookSessionResponse> transformer = DeleteNotebookSessionConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (DeleteNotebookSessionResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteNotebookSessionResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteNotebookSessionResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public DeleteProjectResponse deleteProject(DeleteProjectRequest request) {
        LOG.trace("Called deleteProject");
        DeleteProjectRequest interceptedRequest = DeleteProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteProjectConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "DeleteProject", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Project/DeleteProject");
        Function<Response, DeleteProjectResponse> transformer = DeleteProjectConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (DeleteProjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteProjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteProjectResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetJobResponse getJob(GetJobRequest request) {
        LOG.trace("Called getJob");
        GetJobRequest interceptedRequest = GetJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "GetJob", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Job/GetJob");
        Function<Response, GetJobResponse> transformer = GetJobConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (GetJobResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetJobResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetJobResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetJobArtifactContentResponse getJobArtifactContent(GetJobArtifactContentRequest request) {
        LOG.trace("Called getJobArtifactContent");
        if (ApacheUtils.isExtraStreamLogsEnabled()) {
            LOG.warn("getJobArtifactContent returns a stream, please make sure to close the stream to avoid any indefinite hangs");
            if (this.apacheConnectionClosingStrategy != null) {
                LOG.warn("ApacheConnectionClosingStrategy set to {}. For large streams with partial reads of stream, please use ImmediateClosingStrategy. For small streams with partial reads of stream, please use GracefulClosingStrategy. More info in ApacheConnectorProperties", (Object)this.apacheConnectionClosingStrategy);
            }
        }
        GetJobArtifactContentRequest interceptedRequest = GetJobArtifactContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobArtifactContentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "GetJobArtifactContent", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Job/GetJobArtifactContent");
        Function<Response, GetJobArtifactContentResponse> transformer = GetJobArtifactContentConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (GetJobArtifactContentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetJobArtifactContentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetJobArtifactContentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetJobRunResponse getJobRun(GetJobRunRequest request) {
        LOG.trace("Called getJobRun");
        GetJobRunRequest interceptedRequest = GetJobRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobRunConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "GetJobRun", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/JobRun/GetJobRun");
        Function<Response, GetJobRunResponse> transformer = GetJobRunConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (GetJobRunResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetJobRunResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetJobRunResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetModelResponse getModel(GetModelRequest request) {
        LOG.trace("Called getModel");
        GetModelRequest interceptedRequest = GetModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModelConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "GetModel", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/GetModel");
        Function<Response, GetModelResponse> transformer = GetModelConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (GetModelResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetModelResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetModelResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetModelArtifactContentResponse getModelArtifactContent(GetModelArtifactContentRequest request) {
        LOG.trace("Called getModelArtifactContent");
        if (ApacheUtils.isExtraStreamLogsEnabled()) {
            LOG.warn("getModelArtifactContent returns a stream, please make sure to close the stream to avoid any indefinite hangs");
            if (this.apacheConnectionClosingStrategy != null) {
                LOG.warn("ApacheConnectionClosingStrategy set to {}. For large streams with partial reads of stream, please use ImmediateClosingStrategy. For small streams with partial reads of stream, please use GracefulClosingStrategy. More info in ApacheConnectorProperties", (Object)this.apacheConnectionClosingStrategy);
            }
        }
        GetModelArtifactContentRequest interceptedRequest = GetModelArtifactContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModelArtifactContentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "GetModelArtifactContent", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/GetModelArtifactContent");
        Function<Response, GetModelArtifactContentResponse> transformer = GetModelArtifactContentConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (GetModelArtifactContentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetModelArtifactContentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetModelArtifactContentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetModelDeploymentResponse getModelDeployment(GetModelDeploymentRequest request) {
        LOG.trace("Called getModelDeployment");
        GetModelDeploymentRequest interceptedRequest = GetModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "GetModelDeployment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ModelDeployment/GetModelDeployment");
        Function<Response, GetModelDeploymentResponse> transformer = GetModelDeploymentConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (GetModelDeploymentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetModelDeploymentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetModelDeploymentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetModelProvenanceResponse getModelProvenance(GetModelProvenanceRequest request) {
        LOG.trace("Called getModelProvenance");
        GetModelProvenanceRequest interceptedRequest = GetModelProvenanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModelProvenanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "GetModelProvenance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/GetModelProvenance");
        Function<Response, GetModelProvenanceResponse> transformer = GetModelProvenanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (GetModelProvenanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetModelProvenanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetModelProvenanceResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetNotebookSessionResponse getNotebookSession(GetNotebookSessionRequest request) {
        LOG.trace("Called getNotebookSession");
        GetNotebookSessionRequest interceptedRequest = GetNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "GetNotebookSession", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/NotebookSession/GetNotebookSession");
        Function<Response, GetNotebookSessionResponse> transformer = GetNotebookSessionConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (GetNotebookSessionResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetNotebookSessionResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetNotebookSessionResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetProjectResponse getProject(GetProjectRequest request) {
        LOG.trace("Called getProject");
        GetProjectRequest interceptedRequest = GetProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetProjectConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "GetProject", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Project/GetProject");
        Function<Response, GetProjectResponse> transformer = GetProjectConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (GetProjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetProjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetProjectResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "GetWorkRequest", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/WorkRequest/GetWorkRequest");
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (GetWorkRequestResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public HeadJobArtifactResponse headJobArtifact(HeadJobArtifactRequest request) {
        LOG.trace("Called headJobArtifact");
        HeadJobArtifactRequest interceptedRequest = HeadJobArtifactConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = HeadJobArtifactConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "HeadJobArtifact", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Job/HeadJobArtifact");
        Function<Response, HeadJobArtifactResponse> transformer = HeadJobArtifactConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (HeadJobArtifactResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (HeadJobArtifactResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.head(ib, (BmcRequest)retriedRequest);
                return (HeadJobArtifactResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public HeadModelArtifactResponse headModelArtifact(HeadModelArtifactRequest request) {
        LOG.trace("Called headModelArtifact");
        HeadModelArtifactRequest interceptedRequest = HeadModelArtifactConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = HeadModelArtifactConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "HeadModelArtifact", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/HeadModelArtifact");
        Function<Response, HeadModelArtifactResponse> transformer = HeadModelArtifactConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (HeadModelArtifactResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (HeadModelArtifactResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.head(ib, (BmcRequest)retriedRequest);
                return (HeadModelArtifactResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListFastLaunchJobConfigsResponse listFastLaunchJobConfigs(ListFastLaunchJobConfigsRequest request) {
        LOG.trace("Called listFastLaunchJobConfigs");
        ListFastLaunchJobConfigsRequest interceptedRequest = ListFastLaunchJobConfigsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListFastLaunchJobConfigsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ListFastLaunchJobConfigs", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/FastLaunchJobConfigSummary/ListFastLaunchJobConfigs");
        Function<Response, ListFastLaunchJobConfigsResponse> transformer = ListFastLaunchJobConfigsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListFastLaunchJobConfigsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListFastLaunchJobConfigsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListFastLaunchJobConfigsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListJobRunsResponse listJobRuns(ListJobRunsRequest request) {
        LOG.trace("Called listJobRuns");
        ListJobRunsRequest interceptedRequest = ListJobRunsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobRunsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ListJobRuns", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/JobRunSummary/ListJobRuns");
        Function<Response, ListJobRunsResponse> transformer = ListJobRunsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListJobRunsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListJobRunsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListJobRunsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListJobShapesResponse listJobShapes(ListJobShapesRequest request) {
        LOG.trace("Called listJobShapes");
        ListJobShapesRequest interceptedRequest = ListJobShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobShapesConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ListJobShapes", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/JobShapeSummary/ListJobShapes");
        Function<Response, ListJobShapesResponse> transformer = ListJobShapesConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListJobShapesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListJobShapesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListJobShapesResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListJobsResponse listJobs(ListJobsRequest request) {
        LOG.trace("Called listJobs");
        ListJobsRequest interceptedRequest = ListJobsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ListJobs", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/JobSummary/ListJobs");
        Function<Response, ListJobsResponse> transformer = ListJobsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListJobsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListJobsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListJobsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListModelDeploymentShapesResponse listModelDeploymentShapes(ListModelDeploymentShapesRequest request) {
        LOG.trace("Called listModelDeploymentShapes");
        ListModelDeploymentShapesRequest interceptedRequest = ListModelDeploymentShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModelDeploymentShapesConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ListModelDeploymentShapes", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ModelDeploymentShapeSummary/ListModelDeploymentShapes");
        Function<Response, ListModelDeploymentShapesResponse> transformer = ListModelDeploymentShapesConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListModelDeploymentShapesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListModelDeploymentShapesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListModelDeploymentShapesResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListModelDeploymentsResponse listModelDeployments(ListModelDeploymentsRequest request) {
        LOG.trace("Called listModelDeployments");
        ListModelDeploymentsRequest interceptedRequest = ListModelDeploymentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModelDeploymentsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ListModelDeployments", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ModelDeploymentSummary/ListModelDeployments");
        Function<Response, ListModelDeploymentsResponse> transformer = ListModelDeploymentsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListModelDeploymentsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListModelDeploymentsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListModelDeploymentsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListModelsResponse listModels(ListModelsRequest request) {
        LOG.trace("Called listModels");
        ListModelsRequest interceptedRequest = ListModelsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModelsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ListModels", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ModelSummary/ListModels");
        Function<Response, ListModelsResponse> transformer = ListModelsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListModelsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListModelsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListModelsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListNotebookSessionShapesResponse listNotebookSessionShapes(ListNotebookSessionShapesRequest request) {
        LOG.trace("Called listNotebookSessionShapes");
        ListNotebookSessionShapesRequest interceptedRequest = ListNotebookSessionShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNotebookSessionShapesConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ListNotebookSessionShapes", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/NotebookSessionShapeSummary/ListNotebookSessionShapes");
        Function<Response, ListNotebookSessionShapesResponse> transformer = ListNotebookSessionShapesConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListNotebookSessionShapesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListNotebookSessionShapesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListNotebookSessionShapesResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListNotebookSessionsResponse listNotebookSessions(ListNotebookSessionsRequest request) {
        LOG.trace("Called listNotebookSessions");
        ListNotebookSessionsRequest interceptedRequest = ListNotebookSessionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListNotebookSessionsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ListNotebookSessions", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/NotebookSessionSummary/ListNotebookSessions");
        Function<Response, ListNotebookSessionsResponse> transformer = ListNotebookSessionsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListNotebookSessionsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListNotebookSessionsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListNotebookSessionsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListProjectsResponse listProjects(ListProjectsRequest request) {
        LOG.trace("Called listProjects");
        ListProjectsRequest interceptedRequest = ListProjectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListProjectsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ListProjects", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ProjectSummary/ListProjects");
        Function<Response, ListProjectsResponse> transformer = ListProjectsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListProjectsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListProjectsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListProjectsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ListWorkRequestErrors", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/WorkRequest/ListWorkRequestErrors");
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListWorkRequestErrorsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ListWorkRequestLogs", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/WorkRequest/ListWorkRequestLogs");
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListWorkRequestLogsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "ListWorkRequests", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/WorkRequestSummary/ListWorkRequests");
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (ListWorkRequestsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public UpdateJobResponse updateJob(UpdateJobRequest request) {
        LOG.trace("Called updateJob");
        UpdateJobRequest interceptedRequest = UpdateJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateJobConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "UpdateJob", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Job/UpdateJob");
        Function<Response, UpdateJobResponse> transformer = UpdateJobConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (UpdateJobResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateJobResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateJobDetails(), (BmcRequest)retriedRequest);
                return (UpdateJobResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public UpdateJobRunResponse updateJobRun(UpdateJobRunRequest request) {
        LOG.trace("Called updateJobRun");
        UpdateJobRunRequest interceptedRequest = UpdateJobRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateJobRunConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "UpdateJobRun", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/JobRun/UpdateJobRun");
        Function<Response, UpdateJobRunResponse> transformer = UpdateJobRunConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (UpdateJobRunResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateJobRunResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateJobRunDetails(), (BmcRequest)retriedRequest);
                return (UpdateJobRunResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public UpdateModelResponse updateModel(UpdateModelRequest request) {
        LOG.trace("Called updateModel");
        UpdateModelRequest interceptedRequest = UpdateModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateModelConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "UpdateModel", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/UpdateModel");
        Function<Response, UpdateModelResponse> transformer = UpdateModelConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (UpdateModelResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateModelResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateModelDetails(), (BmcRequest)retriedRequest);
                return (UpdateModelResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public UpdateModelDeploymentResponse updateModelDeployment(UpdateModelDeploymentRequest request) {
        LOG.trace("Called updateModelDeployment");
        UpdateModelDeploymentRequest interceptedRequest = UpdateModelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateModelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "UpdateModelDeployment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ModelDeployment/UpdateModelDeployment");
        Function<Response, UpdateModelDeploymentResponse> transformer = UpdateModelDeploymentConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (UpdateModelDeploymentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateModelDeploymentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateModelDeploymentDetails(), (BmcRequest)retriedRequest);
                return (UpdateModelDeploymentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public UpdateModelProvenanceResponse updateModelProvenance(UpdateModelProvenanceRequest request) {
        LOG.trace("Called updateModelProvenance");
        UpdateModelProvenanceRequest interceptedRequest = UpdateModelProvenanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateModelProvenanceConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "UpdateModelProvenance", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/UpdateModelProvenance");
        Function<Response, UpdateModelProvenanceResponse> transformer = UpdateModelProvenanceConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (UpdateModelProvenanceResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateModelProvenanceResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateModelProvenanceDetails(), (BmcRequest)retriedRequest);
                return (UpdateModelProvenanceResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public UpdateNotebookSessionResponse updateNotebookSession(UpdateNotebookSessionRequest request) {
        LOG.trace("Called updateNotebookSession");
        UpdateNotebookSessionRequest interceptedRequest = UpdateNotebookSessionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateNotebookSessionConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "UpdateNotebookSession", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/NotebookSession/UpdateNotebookSession");
        Function<Response, UpdateNotebookSessionResponse> transformer = UpdateNotebookSessionConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (UpdateNotebookSessionResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateNotebookSessionResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateNotebookSessionDetails(), (BmcRequest)retriedRequest);
                return (UpdateNotebookSessionResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public UpdateProjectResponse updateProject(UpdateProjectRequest request) {
        LOG.trace("Called updateProject");
        UpdateProjectRequest interceptedRequest = UpdateProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateProjectConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("DataScience", "UpdateProject", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Project/UpdateProject");
        Function<Response, UpdateProjectResponse> transformer = UpdateProjectConverter.fromResponse(java.util.Optional.of(serviceDetails));
        return (UpdateProjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateProjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateProjectDetails(), (BmcRequest)retriedRequest);
                return (UpdateProjectResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public DataScienceWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DataSciencePaginators getPaginators() {
        return this.paginators;
    }

    private static boolean shouldRetryBecauseOfWaiterConfiguration(BmcGenericRetrier retrier) {
        boolean hasTerminationStrategy = false;
        boolean isMaxAttemptsTerminationStrategy = false;
        if (retrier.getWaiter() != null && retrier.getWaiter().getWaiterConfiguration() != null) {
            boolean bl = hasTerminationStrategy = retrier.getWaiter().getWaiterConfiguration().getTerminationStrategy() != null;
            if (hasTerminationStrategy) {
                isMaxAttemptsTerminationStrategy = retrier.getWaiter().getWaiterConfiguration().getTerminationStrategy() instanceof MaxAttemptsTerminationStrategy;
            }
        }
        boolean shouldRetry = hasTerminationStrategy && (!isMaxAttemptsTerminationStrategy || isMaxAttemptsTerminationStrategy && ((MaxAttemptsTerminationStrategy)retrier.getWaiter().getWaiterConfiguration().getTerminationStrategy()).getMaxAttempts() > 1);
        return shouldRetry;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataScienceClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DataScienceClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new DataScienceClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

