/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.internal.http;

import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.datascience.requests.GetJobArtifactContentRequest;
import com.oracle.bmc.datascience.responses.GetJobArtifactContentResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactoryV2;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import com.oracle.bmc.util.internal.Validate;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetJobArtifactContentConverter {
    private static final ResponseConversionFunctionFactoryV2 RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactoryV2();
    private static final Logger LOG = LoggerFactory.getLogger(GetJobArtifactContentConverter.class);

    public static GetJobArtifactContentRequest interceptRequest(GetJobArtifactContentRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetJobArtifactContentRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190101").path("jobs").path(HttpUtils.encodePathSegment((String)request.getJobId())).path("artifact").path("content");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/octet-stream"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getRange() != null) {
            ib.header("range", (Object)request.getRange());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, GetJobArtifactContentResponse> fromResponse() {
        return GetJobArtifactContentConverter.fromResponse(Optional.empty());
    }

    public static Function<Response, GetJobArtifactContentResponse> fromResponse(final Optional<ServiceDetails> serviceDetails) {
        Function<Response, GetJobArtifactContentResponse> transformer = new Function<Response, GetJobArtifactContentResponse>(){

            @Override
            public GetJobArtifactContentResponse apply(Response rawResponse) {
                Optional contentDispositionHeader;
                Optional lastModifiedHeader;
                Optional contentMd5Header;
                Optional contentLengthHeader;
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.datascience.responses.GetJobArtifactContentResponse");
                Function responseFn = serviceDetails.isPresent() ? RESPONSE_CONVERSION_FACTORY.create(InputStream.class, (ServiceDetails)serviceDetails.get()) : RESPONSE_CONVERSION_FACTORY.create(InputStream.class);
                WithHeaders response = (WithHeaders)responseFn.apply(rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetJobArtifactContentResponse.Builder builder = GetJobArtifactContentResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.inputStream((InputStream)response.getItem());
                Optional etagHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((contentLengthHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"content-length")).isPresent()) {
                    builder.contentLength((Long)HeaderUtils.toValue((String)"content-length", (String)((String)((List)contentLengthHeader.get()).get(0)), Long.class));
                }
                if ((contentMd5Header = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"content-md5")).isPresent()) {
                    builder.contentMd5((String)HeaderUtils.toValue((String)"content-md5", (String)((String)((List)contentMd5Header.get()).get(0)), String.class));
                }
                if ((lastModifiedHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"last-modified")).isPresent()) {
                    builder.lastModified((Date)HeaderUtils.toValue((String)"last-modified", (String)((String)((List)lastModifiedHeader.get()).get(0)), Date.class));
                }
                if ((contentDispositionHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"content-disposition")).isPresent()) {
                    builder.contentDisposition((String)HeaderUtils.toValue((String)"content-disposition", (String)((String)((List)contentDispositionHeader.get()).get(0)), String.class));
                }
                GetJobArtifactContentResponse responseWrapper = builder.build();
                return responseWrapper;
            }
        };
        return transformer;
    }
}

