/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.internal.http;

import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.datascience.model.Project;
import com.oracle.bmc.datascience.requests.GetProjectRequest;
import com.oracle.bmc.datascience.responses.GetProjectResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactoryV2;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetProjectConverter {
    private static final ResponseConversionFunctionFactoryV2 RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactoryV2();
    private static final Logger LOG = LoggerFactory.getLogger(GetProjectConverter.class);

    public static GetProjectRequest interceptRequest(GetProjectRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetProjectRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190101").path("projects").path(HttpUtils.encodePathSegment((String)request.getProjectId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, GetProjectResponse> fromResponse() {
        return GetProjectConverter.fromResponse(Optional.empty());
    }

    public static Function<Response, GetProjectResponse> fromResponse(final Optional<ServiceDetails> serviceDetails) {
        Function<Response, GetProjectResponse> transformer = new Function<Response, GetProjectResponse>(){

            @Override
            public GetProjectResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.datascience.responses.GetProjectResponse");
                Function responseFn = serviceDetails.isPresent() ? RESPONSE_CONVERSION_FACTORY.create(Project.class, (ServiceDetails)serviceDetails.get()) : RESPONSE_CONVERSION_FACTORY.create(Project.class);
                WithHeaders response = (WithHeaders)responseFn.apply(rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetProjectResponse.Builder builder = GetProjectResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.project((Project)response.getItem());
                Optional etagHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetProjectResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

