/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.internal.http;

import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.datascience.model.NotebookSessionSummary;
import com.oracle.bmc.datascience.requests.ListNotebookSessionsRequest;
import com.oracle.bmc.datascience.responses.ListNotebookSessionsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactoryV2;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListNotebookSessionsConverter {
    private static final ResponseConversionFunctionFactoryV2 RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactoryV2();
    private static final Logger LOG = LoggerFactory.getLogger(ListNotebookSessionsConverter.class);

    public static ListNotebookSessionsRequest interceptRequest(ListNotebookSessionsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListNotebookSessionsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190101").path("notebookSessions");
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getId() != null) {
            target = target.queryParam("id", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getId())});
        }
        if (request.getProjectId() != null) {
            target = target.queryParam("projectId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getProjectId())});
        }
        if (request.getDisplayName() != null) {
            target = target.queryParam("displayName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDisplayName())});
        }
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLifecycleState().getValue())});
        }
        if (request.getCreatedBy() != null) {
            target = target.queryParam("createdBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCreatedBy())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, ListNotebookSessionsResponse> fromResponse() {
        return ListNotebookSessionsConverter.fromResponse(Optional.empty());
    }

    public static Function<Response, ListNotebookSessionsResponse> fromResponse(final Optional<ServiceDetails> serviceDetails) {
        Function<Response, ListNotebookSessionsResponse> transformer = new Function<Response, ListNotebookSessionsResponse>(){

            @Override
            public ListNotebookSessionsResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                Optional opcPrevPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.datascience.responses.ListNotebookSessionsResponse");
                Function responseFn = serviceDetails.isPresent() ? RESPONSE_CONVERSION_FACTORY.create((GenericType)new GenericType<List<NotebookSessionSummary>>(){}, (ServiceDetails)serviceDetails.get()) : RESPONSE_CONVERSION_FACTORY.create((GenericType)new GenericType<List<NotebookSessionSummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply(rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListNotebookSessionsResponse.Builder builder = ListNotebookSessionsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.items((List)response.getItem());
                Optional opcNextPageHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-next-page");
                if (opcNextPageHeader.isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                if ((opcPrevPageHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-prev-page")).isPresent()) {
                    builder.opcPrevPage((String)HeaderUtils.toValue((String)"opc-prev-page", (String)((String)((List)opcPrevPageHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ListNotebookSessionsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

