/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datascience.model.CreateModelProvenanceDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.util.Objects;
import javax.ws.rs.client.Invocation;

public class CreateModelProvenanceRequest
extends BmcRequest<CreateModelProvenanceDetails> {
    private String modelId;
    private CreateModelProvenanceDetails createModelProvenanceDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getModelId() {
        return this.modelId;
    }

    public CreateModelProvenanceDetails getCreateModelProvenanceDetails() {
        return this.createModelProvenanceDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateModelProvenanceDetails getBody$() {
        return this.createModelProvenanceDetails;
    }

    public Builder toBuilder() {
        return new Builder().modelId(this.modelId).createModelProvenanceDetails(this.createModelProvenanceDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",modelId=").append(String.valueOf(this.modelId));
        sb.append(",createModelProvenanceDetails=").append(String.valueOf(this.createModelProvenanceDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateModelProvenanceRequest)) {
            return false;
        }
        CreateModelProvenanceRequest other = (CreateModelProvenanceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.modelId, other.modelId) && Objects.equals(this.createModelProvenanceDetails, other.createModelProvenanceDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.modelId == null ? 43 : this.modelId.hashCode());
        result = result * 59 + (this.createModelProvenanceDetails == null ? 43 : this.createModelProvenanceDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateModelProvenanceRequest, CreateModelProvenanceDetails> {
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String modelId = null;
        private CreateModelProvenanceDetails createModelProvenanceDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder createModelProvenanceDetails(CreateModelProvenanceDetails createModelProvenanceDetails) {
            this.createModelProvenanceDetails = createModelProvenanceDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateModelProvenanceRequest o) {
            this.modelId(o.getModelId());
            this.createModelProvenanceDetails(o.getCreateModelProvenanceDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateModelProvenanceRequest build() {
            CreateModelProvenanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateModelProvenanceDetails body) {
            this.createModelProvenanceDetails(body);
            return this;
        }

        public CreateModelProvenanceRequest buildWithoutInvocationCallback() {
            CreateModelProvenanceRequest request = new CreateModelProvenanceRequest();
            request.modelId = this.modelId;
            request.createModelProvenanceDetails = this.createModelProvenanceDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

