/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datascience.model.CreateProjectDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.util.Objects;
import javax.ws.rs.client.Invocation;

public class CreateProjectRequest
extends BmcRequest<CreateProjectDetails> {
    private CreateProjectDetails createProjectDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public CreateProjectDetails getCreateProjectDetails() {
        return this.createProjectDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateProjectDetails getBody$() {
        return this.createProjectDetails;
    }

    public Builder toBuilder() {
        return new Builder().createProjectDetails(this.createProjectDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createProjectDetails=").append(String.valueOf(this.createProjectDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateProjectRequest)) {
            return false;
        }
        CreateProjectRequest other = (CreateProjectRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.createProjectDetails, other.createProjectDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createProjectDetails == null ? 43 : this.createProjectDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateProjectRequest, CreateProjectDetails> {
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateProjectDetails createProjectDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder createProjectDetails(CreateProjectDetails createProjectDetails) {
            this.createProjectDetails = createProjectDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateProjectRequest o) {
            this.createProjectDetails(o.getCreateProjectDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateProjectRequest build() {
            CreateProjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateProjectDetails body) {
            this.createProjectDetails(body);
            return this;
        }

        public CreateProjectRequest buildWithoutInvocationCallback() {
            CreateProjectRequest request = new CreateProjectRequest();
            request.createProjectDetails = this.createProjectDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

