/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datascience.model.UpdateProjectDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.util.Objects;
import javax.ws.rs.client.Invocation;

public class UpdateProjectRequest
extends BmcRequest<UpdateProjectDetails> {
    private String projectId;
    private UpdateProjectDetails updateProjectDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getProjectId() {
        return this.projectId;
    }

    public UpdateProjectDetails getUpdateProjectDetails() {
        return this.updateProjectDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateProjectDetails getBody$() {
        return this.updateProjectDetails;
    }

    public Builder toBuilder() {
        return new Builder().projectId(this.projectId).updateProjectDetails(this.updateProjectDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",projectId=").append(String.valueOf(this.projectId));
        sb.append(",updateProjectDetails=").append(String.valueOf(this.updateProjectDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateProjectRequest)) {
            return false;
        }
        UpdateProjectRequest other = (UpdateProjectRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.projectId, other.projectId) && Objects.equals(this.updateProjectDetails, other.updateProjectDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.projectId == null ? 43 : this.projectId.hashCode());
        result = result * 59 + (this.updateProjectDetails == null ? 43 : this.updateProjectDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateProjectRequest, UpdateProjectDetails> {
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String projectId = null;
        private UpdateProjectDetails updateProjectDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder updateProjectDetails(UpdateProjectDetails updateProjectDetails) {
            this.updateProjectDetails = updateProjectDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateProjectRequest o) {
            this.projectId(o.getProjectId());
            this.updateProjectDetails(o.getUpdateProjectDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateProjectRequest build() {
            UpdateProjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateProjectDetails body) {
            this.updateProjectDetails(body);
            return this;
        }

        public UpdateProjectRequest buildWithoutInvocationCallback() {
            UpdateProjectRequest request = new UpdateProjectRequest();
            request.projectId = this.projectId;
            request.updateProjectDetails = this.updateProjectDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

