/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.internal.http;

import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.datascience.model.JobShapeSummary;
import com.oracle.bmc.datascience.requests.ListJobShapesRequest;
import com.oracle.bmc.datascience.responses.ListJobShapesResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactoryV2;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListJobShapesConverter {
    private static final ResponseConversionFunctionFactoryV2 RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactoryV2();
    private static final Logger LOG = LoggerFactory.getLogger(ListJobShapesConverter.class);

    public static ListJobShapesRequest interceptRequest(ListJobShapesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListJobShapesRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190101").path("jobShapes");
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, ListJobShapesResponse> fromResponse() {
        return ListJobShapesConverter.fromResponse(Optional.empty());
    }

    public static Function<Response, ListJobShapesResponse> fromResponse(final Optional<ServiceDetails> serviceDetails) {
        Function<Response, ListJobShapesResponse> transformer = new Function<Response, ListJobShapesResponse>(){

            @Override
            public ListJobShapesResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                Optional opcPrevPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.datascience.responses.ListJobShapesResponse");
                Function responseFn = serviceDetails.isPresent() ? RESPONSE_CONVERSION_FACTORY.create((GenericType)new GenericType<List<JobShapeSummary>>(){}, (ServiceDetails)serviceDetails.get()) : RESPONSE_CONVERSION_FACTORY.create((GenericType)new GenericType<List<JobShapeSummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply(rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListJobShapesResponse.Builder builder = ListJobShapesResponse.builder().__httpStatusCode__(rawResponse.getStatus()).headers((MultivaluedMap<String, String>)headers);
                builder.items((List)response.getItem());
                Optional opcNextPageHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-next-page");
                if (opcNextPageHeader.isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                if ((opcPrevPageHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-prev-page")).isPresent()) {
                    builder.opcPrevPage((String)HeaderUtils.toValue((String)"opc-prev-page", (String)((String)((List)opcPrevPageHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ListJobShapesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

