/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.internal.http;

import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.datascience.model.WorkRequestError;
import com.oracle.bmc.datascience.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.datascience.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactoryV2;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListWorkRequestErrorsConverter {
    private static final ResponseConversionFunctionFactoryV2 RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactoryV2();
    private static final Logger LOG = LoggerFactory.getLogger(ListWorkRequestErrorsConverter.class);

    public static ListWorkRequestErrorsRequest interceptRequest(ListWorkRequestErrorsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListWorkRequestErrorsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190101").path("workRequests").path(HttpUtils.encodePathSegment((String)request.getWorkRequestId())).path("errors");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, ListWorkRequestErrorsResponse> fromResponse() {
        return ListWorkRequestErrorsConverter.fromResponse(Optional.empty());
    }

    public static Function<Response, ListWorkRequestErrorsResponse> fromResponse(final Optional<ServiceDetails> serviceDetails) {
        Function<Response, ListWorkRequestErrorsResponse> transformer = new Function<Response, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.datascience.responses.ListWorkRequestErrorsResponse");
                Function responseFn = serviceDetails.isPresent() ? RESPONSE_CONVERSION_FACTORY.create((GenericType)new GenericType<List<WorkRequestError>>(){}, (ServiceDetails)serviceDetails.get()) : RESPONSE_CONVERSION_FACTORY.create((GenericType)new GenericType<List<WorkRequestError>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply(rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListWorkRequestErrorsResponse.Builder builder = ListWorkRequestErrorsResponse.builder().__httpStatusCode__(rawResponse.getStatus()).headers((MultivaluedMap<String, String>)headers);
                builder.items((List)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ListWorkRequestErrorsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

