/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datascience.model.JobConfigurationDetails;
import com.oracle.bmc.datascience.model.JobInfrastructureConfigurationDetails;
import com.oracle.bmc.datascience.model.JobLogConfigurationDetails;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateJobDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="projectId")
    private final String projectId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="jobConfigurationDetails")
    private final JobConfigurationDetails jobConfigurationDetails;
    @JsonProperty(value="jobInfrastructureConfigurationDetails")
    private final JobInfrastructureConfigurationDetails jobInfrastructureConfigurationDetails;
    @JsonProperty(value="jobLogConfigurationDetails")
    private final JobLogConfigurationDetails jobLogConfigurationDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"projectId", "compartmentId", "displayName", "description", "jobConfigurationDetails", "jobInfrastructureConfigurationDetails", "jobLogConfigurationDetails", "freeformTags", "definedTags"})
    public CreateJobDetails(String projectId, String compartmentId, String displayName, String description, JobConfigurationDetails jobConfigurationDetails, JobInfrastructureConfigurationDetails jobInfrastructureConfigurationDetails, JobLogConfigurationDetails jobLogConfigurationDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.projectId = projectId;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.description = description;
        this.jobConfigurationDetails = jobConfigurationDetails;
        this.jobInfrastructureConfigurationDetails = jobInfrastructureConfigurationDetails;
        this.jobLogConfigurationDetails = jobLogConfigurationDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public JobConfigurationDetails getJobConfigurationDetails() {
        return this.jobConfigurationDetails;
    }

    public JobInfrastructureConfigurationDetails getJobInfrastructureConfigurationDetails() {
        return this.jobInfrastructureConfigurationDetails;
    }

    public JobLogConfigurationDetails getJobLogConfigurationDetails() {
        return this.jobLogConfigurationDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateJobDetails(");
        sb.append("super=").append(super.toString());
        sb.append("projectId=").append(String.valueOf(this.projectId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", jobConfigurationDetails=").append(String.valueOf((Object)this.jobConfigurationDetails));
        sb.append(", jobInfrastructureConfigurationDetails=").append(String.valueOf((Object)this.jobInfrastructureConfigurationDetails));
        sb.append(", jobLogConfigurationDetails=").append(String.valueOf((Object)this.jobLogConfigurationDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateJobDetails)) {
            return false;
        }
        CreateJobDetails other = (CreateJobDetails)((Object)o);
        return Objects.equals(this.projectId, other.projectId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.jobConfigurationDetails, (Object)other.jobConfigurationDetails) && Objects.equals((Object)this.jobInfrastructureConfigurationDetails, (Object)other.jobInfrastructureConfigurationDetails) && Objects.equals((Object)this.jobLogConfigurationDetails, (Object)other.jobLogConfigurationDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.projectId == null ? 43 : this.projectId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.jobConfigurationDetails == null ? 43 : this.jobConfigurationDetails.hashCode());
        result = result * 59 + (this.jobInfrastructureConfigurationDetails == null ? 43 : this.jobInfrastructureConfigurationDetails.hashCode());
        result = result * 59 + (this.jobLogConfigurationDetails == null ? 43 : this.jobLogConfigurationDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="projectId")
        private String projectId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="jobConfigurationDetails")
        private JobConfigurationDetails jobConfigurationDetails;
        @JsonProperty(value="jobInfrastructureConfigurationDetails")
        private JobInfrastructureConfigurationDetails jobInfrastructureConfigurationDetails;
        @JsonProperty(value="jobLogConfigurationDetails")
        private JobLogConfigurationDetails jobLogConfigurationDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            this.__explicitlySet__.add("projectId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder jobConfigurationDetails(JobConfigurationDetails jobConfigurationDetails) {
            this.jobConfigurationDetails = jobConfigurationDetails;
            this.__explicitlySet__.add("jobConfigurationDetails");
            return this;
        }

        public Builder jobInfrastructureConfigurationDetails(JobInfrastructureConfigurationDetails jobInfrastructureConfigurationDetails) {
            this.jobInfrastructureConfigurationDetails = jobInfrastructureConfigurationDetails;
            this.__explicitlySet__.add("jobInfrastructureConfigurationDetails");
            return this;
        }

        public Builder jobLogConfigurationDetails(JobLogConfigurationDetails jobLogConfigurationDetails) {
            this.jobLogConfigurationDetails = jobLogConfigurationDetails;
            this.__explicitlySet__.add("jobLogConfigurationDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateJobDetails build() {
            CreateJobDetails model = new CreateJobDetails(this.projectId, this.compartmentId, this.displayName, this.description, this.jobConfigurationDetails, this.jobInfrastructureConfigurationDetails, this.jobLogConfigurationDetails, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateJobDetails model) {
            if (model.wasPropertyExplicitlySet("projectId")) {
                this.projectId(model.getProjectId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("jobConfigurationDetails")) {
                this.jobConfigurationDetails(model.getJobConfigurationDetails());
            }
            if (model.wasPropertyExplicitlySet("jobInfrastructureConfigurationDetails")) {
                this.jobInfrastructureConfigurationDetails(model.getJobInfrastructureConfigurationDetails());
            }
            if (model.wasPropertyExplicitlySet("jobLogConfigurationDetails")) {
                this.jobLogConfigurationDetails(model.getJobLogConfigurationDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

