/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datascience.model.JobConfigurationDetails;
import com.oracle.bmc.datascience.model.JobLogConfigurationDetails;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateJobRunDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="projectId")
    private final String projectId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="jobId")
    private final String jobId;
    @JsonProperty(value="jobConfigurationOverrideDetails")
    private final JobConfigurationDetails jobConfigurationOverrideDetails;
    @JsonProperty(value="jobLogConfigurationOverrideDetails")
    private final JobLogConfigurationDetails jobLogConfigurationOverrideDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"projectId", "compartmentId", "displayName", "jobId", "jobConfigurationOverrideDetails", "jobLogConfigurationOverrideDetails", "freeformTags", "definedTags"})
    public CreateJobRunDetails(String projectId, String compartmentId, String displayName, String jobId, JobConfigurationDetails jobConfigurationOverrideDetails, JobLogConfigurationDetails jobLogConfigurationOverrideDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.projectId = projectId;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.jobId = jobId;
        this.jobConfigurationOverrideDetails = jobConfigurationOverrideDetails;
        this.jobLogConfigurationOverrideDetails = jobLogConfigurationOverrideDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getJobId() {
        return this.jobId;
    }

    public JobConfigurationDetails getJobConfigurationOverrideDetails() {
        return this.jobConfigurationOverrideDetails;
    }

    public JobLogConfigurationDetails getJobLogConfigurationOverrideDetails() {
        return this.jobLogConfigurationOverrideDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateJobRunDetails(");
        sb.append("super=").append(super.toString());
        sb.append("projectId=").append(String.valueOf(this.projectId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", jobId=").append(String.valueOf(this.jobId));
        sb.append(", jobConfigurationOverrideDetails=").append(String.valueOf((Object)this.jobConfigurationOverrideDetails));
        sb.append(", jobLogConfigurationOverrideDetails=").append(String.valueOf((Object)this.jobLogConfigurationOverrideDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateJobRunDetails)) {
            return false;
        }
        CreateJobRunDetails other = (CreateJobRunDetails)((Object)o);
        return Objects.equals(this.projectId, other.projectId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.jobId, other.jobId) && Objects.equals((Object)this.jobConfigurationOverrideDetails, (Object)other.jobConfigurationOverrideDetails) && Objects.equals((Object)this.jobLogConfigurationOverrideDetails, (Object)other.jobLogConfigurationOverrideDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.projectId == null ? 43 : this.projectId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.jobId == null ? 43 : this.jobId.hashCode());
        result = result * 59 + (this.jobConfigurationOverrideDetails == null ? 43 : this.jobConfigurationOverrideDetails.hashCode());
        result = result * 59 + (this.jobLogConfigurationOverrideDetails == null ? 43 : this.jobLogConfigurationOverrideDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="projectId")
        private String projectId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="jobId")
        private String jobId;
        @JsonProperty(value="jobConfigurationOverrideDetails")
        private JobConfigurationDetails jobConfigurationOverrideDetails;
        @JsonProperty(value="jobLogConfigurationOverrideDetails")
        private JobLogConfigurationDetails jobLogConfigurationOverrideDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            this.__explicitlySet__.add("projectId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            this.__explicitlySet__.add("jobId");
            return this;
        }

        public Builder jobConfigurationOverrideDetails(JobConfigurationDetails jobConfigurationOverrideDetails) {
            this.jobConfigurationOverrideDetails = jobConfigurationOverrideDetails;
            this.__explicitlySet__.add("jobConfigurationOverrideDetails");
            return this;
        }

        public Builder jobLogConfigurationOverrideDetails(JobLogConfigurationDetails jobLogConfigurationOverrideDetails) {
            this.jobLogConfigurationOverrideDetails = jobLogConfigurationOverrideDetails;
            this.__explicitlySet__.add("jobLogConfigurationOverrideDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateJobRunDetails build() {
            CreateJobRunDetails model = new CreateJobRunDetails(this.projectId, this.compartmentId, this.displayName, this.jobId, this.jobConfigurationOverrideDetails, this.jobLogConfigurationOverrideDetails, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateJobRunDetails model) {
            if (model.wasPropertyExplicitlySet("projectId")) {
                this.projectId(model.getProjectId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("jobId")) {
                this.jobId(model.getJobId());
            }
            if (model.wasPropertyExplicitlySet("jobConfigurationOverrideDetails")) {
                this.jobConfigurationOverrideDetails(model.getJobConfigurationOverrideDetails());
            }
            if (model.wasPropertyExplicitlySet("jobLogConfigurationOverrideDetails")) {
                this.jobLogConfigurationOverrideDetails(model.getJobLogConfigurationOverrideDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

