/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FastLaunchJobConfigSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="shapeName")
    private final String shapeName;
    @JsonProperty(value="coreCount")
    private final Integer coreCount;
    @JsonProperty(value="memoryInGBs")
    private final Integer memoryInGBs;
    @JsonProperty(value="shapeSeries")
    private final ShapeSeries shapeSeries;
    @JsonProperty(value="managedEgressSupport")
    private final ManagedEgressSupport managedEgressSupport;

    @Deprecated
    @ConstructorProperties(value={"name", "shapeName", "coreCount", "memoryInGBs", "shapeSeries", "managedEgressSupport"})
    public FastLaunchJobConfigSummary(String name, String shapeName, Integer coreCount, Integer memoryInGBs, ShapeSeries shapeSeries, ManagedEgressSupport managedEgressSupport) {
        this.name = name;
        this.shapeName = shapeName;
        this.coreCount = coreCount;
        this.memoryInGBs = memoryInGBs;
        this.shapeSeries = shapeSeries;
        this.managedEgressSupport = managedEgressSupport;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getShapeName() {
        return this.shapeName;
    }

    public Integer getCoreCount() {
        return this.coreCount;
    }

    public Integer getMemoryInGBs() {
        return this.memoryInGBs;
    }

    public ShapeSeries getShapeSeries() {
        return this.shapeSeries;
    }

    public ManagedEgressSupport getManagedEgressSupport() {
        return this.managedEgressSupport;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FastLaunchJobConfigSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", shapeName=").append(String.valueOf(this.shapeName));
        sb.append(", coreCount=").append(String.valueOf(this.coreCount));
        sb.append(", memoryInGBs=").append(String.valueOf(this.memoryInGBs));
        sb.append(", shapeSeries=").append(String.valueOf((Object)this.shapeSeries));
        sb.append(", managedEgressSupport=").append(String.valueOf((Object)this.managedEgressSupport));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FastLaunchJobConfigSummary)) {
            return false;
        }
        FastLaunchJobConfigSummary other = (FastLaunchJobConfigSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.shapeName, other.shapeName) && Objects.equals(this.coreCount, other.coreCount) && Objects.equals(this.memoryInGBs, other.memoryInGBs) && Objects.equals((Object)this.shapeSeries, (Object)other.shapeSeries) && Objects.equals((Object)this.managedEgressSupport, (Object)other.managedEgressSupport) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.shapeName == null ? 43 : this.shapeName.hashCode());
        result = result * 59 + (this.coreCount == null ? 43 : this.coreCount.hashCode());
        result = result * 59 + (this.memoryInGBs == null ? 43 : this.memoryInGBs.hashCode());
        result = result * 59 + (this.shapeSeries == null ? 43 : this.shapeSeries.hashCode());
        result = result * 59 + (this.managedEgressSupport == null ? 43 : this.managedEgressSupport.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ManagedEgressSupport {
        Required("REQUIRED"),
        Supported("SUPPORTED"),
        Unsupported("UNSUPPORTED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ManagedEgressSupport> map;

        private ManagedEgressSupport(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ManagedEgressSupport create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ManagedEgressSupport', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ManagedEgressSupport.class);
            map = new HashMap<String, ManagedEgressSupport>();
            for (ManagedEgressSupport v : ManagedEgressSupport.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ShapeSeries {
        AmdRome("AMD_ROME"),
        IntelSkylake("INTEL_SKYLAKE"),
        NvidiaGpu("NVIDIA_GPU"),
        Legacy("LEGACY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ShapeSeries> map;

        private ShapeSeries(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ShapeSeries create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ShapeSeries', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ShapeSeries.class);
            map = new HashMap<String, ShapeSeries>();
            for (ShapeSeries v : ShapeSeries.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="shapeName")
        private String shapeName;
        @JsonProperty(value="coreCount")
        private Integer coreCount;
        @JsonProperty(value="memoryInGBs")
        private Integer memoryInGBs;
        @JsonProperty(value="shapeSeries")
        private ShapeSeries shapeSeries;
        @JsonProperty(value="managedEgressSupport")
        private ManagedEgressSupport managedEgressSupport;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder shapeName(String shapeName) {
            this.shapeName = shapeName;
            this.__explicitlySet__.add("shapeName");
            return this;
        }

        public Builder coreCount(Integer coreCount) {
            this.coreCount = coreCount;
            this.__explicitlySet__.add("coreCount");
            return this;
        }

        public Builder memoryInGBs(Integer memoryInGBs) {
            this.memoryInGBs = memoryInGBs;
            this.__explicitlySet__.add("memoryInGBs");
            return this;
        }

        public Builder shapeSeries(ShapeSeries shapeSeries) {
            this.shapeSeries = shapeSeries;
            this.__explicitlySet__.add("shapeSeries");
            return this;
        }

        public Builder managedEgressSupport(ManagedEgressSupport managedEgressSupport) {
            this.managedEgressSupport = managedEgressSupport;
            this.__explicitlySet__.add("managedEgressSupport");
            return this;
        }

        public FastLaunchJobConfigSummary build() {
            FastLaunchJobConfigSummary model = new FastLaunchJobConfigSummary(this.name, this.shapeName, this.coreCount, this.memoryInGBs, this.shapeSeries, this.managedEgressSupport);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FastLaunchJobConfigSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("shapeName")) {
                this.shapeName(model.getShapeName());
            }
            if (model.wasPropertyExplicitlySet("coreCount")) {
                this.coreCount(model.getCoreCount());
            }
            if (model.wasPropertyExplicitlySet("memoryInGBs")) {
                this.memoryInGBs(model.getMemoryInGBs());
            }
            if (model.wasPropertyExplicitlySet("shapeSeries")) {
                this.shapeSeries(model.getShapeSeries());
            }
            if (model.wasPropertyExplicitlySet("managedEgressSupport")) {
                this.managedEgressSupport(model.getManagedEgressSupport());
            }
            return this;
        }
    }
}

