/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ModelProvenance
extends ExplicitlySetBmcModel {
    @JsonProperty(value="repositoryUrl")
    private final String repositoryUrl;
    @JsonProperty(value="gitBranch")
    private final String gitBranch;
    @JsonProperty(value="gitCommit")
    private final String gitCommit;
    @JsonProperty(value="scriptDir")
    private final String scriptDir;
    @JsonProperty(value="trainingScript")
    private final String trainingScript;
    @JsonProperty(value="trainingId")
    private final String trainingId;

    @Deprecated
    @ConstructorProperties(value={"repositoryUrl", "gitBranch", "gitCommit", "scriptDir", "trainingScript", "trainingId"})
    public ModelProvenance(String repositoryUrl, String gitBranch, String gitCommit, String scriptDir, String trainingScript, String trainingId) {
        this.repositoryUrl = repositoryUrl;
        this.gitBranch = gitBranch;
        this.gitCommit = gitCommit;
        this.scriptDir = scriptDir;
        this.trainingScript = trainingScript;
        this.trainingId = trainingId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getGitBranch() {
        return this.gitBranch;
    }

    public String getGitCommit() {
        return this.gitCommit;
    }

    public String getScriptDir() {
        return this.scriptDir;
    }

    public String getTrainingScript() {
        return this.trainingScript;
    }

    public String getTrainingId() {
        return this.trainingId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ModelProvenance(");
        sb.append("super=").append(super.toString());
        sb.append("repositoryUrl=").append(String.valueOf(this.repositoryUrl));
        sb.append(", gitBranch=").append(String.valueOf(this.gitBranch));
        sb.append(", gitCommit=").append(String.valueOf(this.gitCommit));
        sb.append(", scriptDir=").append(String.valueOf(this.scriptDir));
        sb.append(", trainingScript=").append(String.valueOf(this.trainingScript));
        sb.append(", trainingId=").append(String.valueOf(this.trainingId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelProvenance)) {
            return false;
        }
        ModelProvenance other = (ModelProvenance)((Object)o);
        return Objects.equals(this.repositoryUrl, other.repositoryUrl) && Objects.equals(this.gitBranch, other.gitBranch) && Objects.equals(this.gitCommit, other.gitCommit) && Objects.equals(this.scriptDir, other.scriptDir) && Objects.equals(this.trainingScript, other.trainingScript) && Objects.equals(this.trainingId, other.trainingId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.repositoryUrl == null ? 43 : this.repositoryUrl.hashCode());
        result = result * 59 + (this.gitBranch == null ? 43 : this.gitBranch.hashCode());
        result = result * 59 + (this.gitCommit == null ? 43 : this.gitCommit.hashCode());
        result = result * 59 + (this.scriptDir == null ? 43 : this.scriptDir.hashCode());
        result = result * 59 + (this.trainingScript == null ? 43 : this.trainingScript.hashCode());
        result = result * 59 + (this.trainingId == null ? 43 : this.trainingId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="repositoryUrl")
        private String repositoryUrl;
        @JsonProperty(value="gitBranch")
        private String gitBranch;
        @JsonProperty(value="gitCommit")
        private String gitCommit;
        @JsonProperty(value="scriptDir")
        private String scriptDir;
        @JsonProperty(value="trainingScript")
        private String trainingScript;
        @JsonProperty(value="trainingId")
        private String trainingId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder repositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
            this.__explicitlySet__.add("repositoryUrl");
            return this;
        }

        public Builder gitBranch(String gitBranch) {
            this.gitBranch = gitBranch;
            this.__explicitlySet__.add("gitBranch");
            return this;
        }

        public Builder gitCommit(String gitCommit) {
            this.gitCommit = gitCommit;
            this.__explicitlySet__.add("gitCommit");
            return this;
        }

        public Builder scriptDir(String scriptDir) {
            this.scriptDir = scriptDir;
            this.__explicitlySet__.add("scriptDir");
            return this;
        }

        public Builder trainingScript(String trainingScript) {
            this.trainingScript = trainingScript;
            this.__explicitlySet__.add("trainingScript");
            return this;
        }

        public Builder trainingId(String trainingId) {
            this.trainingId = trainingId;
            this.__explicitlySet__.add("trainingId");
            return this;
        }

        public ModelProvenance build() {
            ModelProvenance model = new ModelProvenance(this.repositoryUrl, this.gitBranch, this.gitCommit, this.scriptDir, this.trainingScript, this.trainingId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ModelProvenance model) {
            if (model.wasPropertyExplicitlySet("repositoryUrl")) {
                this.repositoryUrl(model.getRepositoryUrl());
            }
            if (model.wasPropertyExplicitlySet("gitBranch")) {
                this.gitBranch(model.getGitBranch());
            }
            if (model.wasPropertyExplicitlySet("gitCommit")) {
                this.gitCommit(model.getGitCommit());
            }
            if (model.wasPropertyExplicitlySet("scriptDir")) {
                this.scriptDir(model.getScriptDir());
            }
            if (model.wasPropertyExplicitlySet("trainingScript")) {
                this.trainingScript(model.getTrainingScript());
            }
            if (model.wasPropertyExplicitlySet("trainingId")) {
                this.trainingId(model.getTrainingId());
            }
            return this;
        }
    }
}

