/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datascience.model.InstanceConfiguration;
import com.oracle.bmc.datascience.model.ScalingPolicy;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateModelConfigurationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="modelId")
    private final String modelId;
    @JsonProperty(value="instanceConfiguration")
    private final InstanceConfiguration instanceConfiguration;
    @JsonProperty(value="scalingPolicy")
    private final ScalingPolicy scalingPolicy;
    @JsonProperty(value="bandwidthMbps")
    private final Integer bandwidthMbps;

    @Deprecated
    @ConstructorProperties(value={"modelId", "instanceConfiguration", "scalingPolicy", "bandwidthMbps"})
    public UpdateModelConfigurationDetails(String modelId, InstanceConfiguration instanceConfiguration, ScalingPolicy scalingPolicy, Integer bandwidthMbps) {
        this.modelId = modelId;
        this.instanceConfiguration = instanceConfiguration;
        this.scalingPolicy = scalingPolicy;
        this.bandwidthMbps = bandwidthMbps;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getModelId() {
        return this.modelId;
    }

    public InstanceConfiguration getInstanceConfiguration() {
        return this.instanceConfiguration;
    }

    public ScalingPolicy getScalingPolicy() {
        return this.scalingPolicy;
    }

    public Integer getBandwidthMbps() {
        return this.bandwidthMbps;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateModelConfigurationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("modelId=").append(String.valueOf(this.modelId));
        sb.append(", instanceConfiguration=").append(String.valueOf((Object)this.instanceConfiguration));
        sb.append(", scalingPolicy=").append(String.valueOf((Object)this.scalingPolicy));
        sb.append(", bandwidthMbps=").append(String.valueOf(this.bandwidthMbps));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateModelConfigurationDetails)) {
            return false;
        }
        UpdateModelConfigurationDetails other = (UpdateModelConfigurationDetails)((Object)o);
        return Objects.equals(this.modelId, other.modelId) && Objects.equals((Object)this.instanceConfiguration, (Object)other.instanceConfiguration) && Objects.equals((Object)this.scalingPolicy, (Object)other.scalingPolicy) && Objects.equals(this.bandwidthMbps, other.bandwidthMbps) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.modelId == null ? 43 : this.modelId.hashCode());
        result = result * 59 + (this.instanceConfiguration == null ? 43 : this.instanceConfiguration.hashCode());
        result = result * 59 + (this.scalingPolicy == null ? 43 : this.scalingPolicy.hashCode());
        result = result * 59 + (this.bandwidthMbps == null ? 43 : this.bandwidthMbps.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="modelId")
        private String modelId;
        @JsonProperty(value="instanceConfiguration")
        private InstanceConfiguration instanceConfiguration;
        @JsonProperty(value="scalingPolicy")
        private ScalingPolicy scalingPolicy;
        @JsonProperty(value="bandwidthMbps")
        private Integer bandwidthMbps;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            this.__explicitlySet__.add("modelId");
            return this;
        }

        public Builder instanceConfiguration(InstanceConfiguration instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration;
            this.__explicitlySet__.add("instanceConfiguration");
            return this;
        }

        public Builder scalingPolicy(ScalingPolicy scalingPolicy) {
            this.scalingPolicy = scalingPolicy;
            this.__explicitlySet__.add("scalingPolicy");
            return this;
        }

        public Builder bandwidthMbps(Integer bandwidthMbps) {
            this.bandwidthMbps = bandwidthMbps;
            this.__explicitlySet__.add("bandwidthMbps");
            return this;
        }

        public UpdateModelConfigurationDetails build() {
            UpdateModelConfigurationDetails model = new UpdateModelConfigurationDetails(this.modelId, this.instanceConfiguration, this.scalingPolicy, this.bandwidthMbps);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateModelConfigurationDetails model) {
            if (model.wasPropertyExplicitlySet("modelId")) {
                this.modelId(model.getModelId());
            }
            if (model.wasPropertyExplicitlySet("instanceConfiguration")) {
                this.instanceConfiguration(model.getInstanceConfiguration());
            }
            if (model.wasPropertyExplicitlySet("scalingPolicy")) {
                this.scalingPolicy(model.getScalingPolicy());
            }
            if (model.wasPropertyExplicitlySet("bandwidthMbps")) {
                this.bandwidthMbps(model.getBandwidthMbps());
            }
            return this;
        }
    }
}

