/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.requests.HasContentLength;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.io.InputStream;
import java.util.Objects;
import javax.ws.rs.client.Invocation;

public class CreateModelArtifactRequest
extends BmcRequest<InputStream>
implements HasContentLength {
    private String modelId;
    private Long contentLength;
    private InputStream modelArtifact;
    private String opcRequestId;
    private String opcRetryToken;
    private String contentDisposition;
    private String ifMatch;

    public String getModelId() {
        return this.modelId;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public InputStream getModelArtifact() {
        return this.modelArtifact;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public InputStream getBody$() {
        return this.modelArtifact;
    }

    public Builder toBuilder() {
        return new Builder().modelId(this.modelId).contentLength(this.contentLength).modelArtifact(this.modelArtifact).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).contentDisposition(this.contentDisposition).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",modelId=").append(String.valueOf(this.modelId));
        sb.append(",contentLength=").append(String.valueOf(this.contentLength));
        sb.append(",modelArtifact=").append(String.valueOf(this.modelArtifact));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",contentDisposition=").append(String.valueOf(this.contentDisposition));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateModelArtifactRequest)) {
            return false;
        }
        CreateModelArtifactRequest other = (CreateModelArtifactRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.modelId, other.modelId) && Objects.equals(this.contentLength, other.contentLength) && Objects.equals(this.modelArtifact, other.modelArtifact) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.contentDisposition, other.contentDisposition) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.modelId == null ? 43 : this.modelId.hashCode());
        result = result * 59 + (this.contentLength == null ? 43 : this.contentLength.hashCode());
        result = result * 59 + (this.modelArtifact == null ? 43 : this.modelArtifact.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.contentDisposition == null ? 43 : this.contentDisposition.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateModelArtifactRequest, InputStream> {
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String modelId = null;
        private Long contentLength = null;
        private InputStream modelArtifact = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String contentDisposition = null;
        private String ifMatch = null;

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public Builder modelArtifact(InputStream modelArtifact) {
            this.modelArtifact = modelArtifact;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateModelArtifactRequest o) {
            this.modelId(o.getModelId());
            this.contentLength(o.getContentLength());
            this.modelArtifact(o.getModelArtifact());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.contentDisposition(o.getContentDisposition());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateModelArtifactRequest build() {
            CreateModelArtifactRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.modelArtifact(body);
            return this;
        }

        public CreateModelArtifactRequest buildWithoutInvocationCallback() {
            CreateModelArtifactRequest request = new CreateModelArtifactRequest();
            request.modelId = this.modelId;
            request.contentLength = this.contentLength;
            request.modelArtifact = this.modelArtifact;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.contentDisposition = this.contentDisposition;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

