/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datascience.model.ExportModelArtifactDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.util.Objects;
import javax.ws.rs.client.Invocation;

public class ExportModelArtifactRequest
extends BmcRequest<ExportModelArtifactDetails> {
    private String modelId;
    private ExportModelArtifactDetails exportModelArtifactDetails;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;

    public String getModelId() {
        return this.modelId;
    }

    public ExportModelArtifactDetails getExportModelArtifactDetails() {
        return this.exportModelArtifactDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public ExportModelArtifactDetails getBody$() {
        return this.exportModelArtifactDetails;
    }

    public Builder toBuilder() {
        return new Builder().modelId(this.modelId).exportModelArtifactDetails(this.exportModelArtifactDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",modelId=").append(String.valueOf(this.modelId));
        sb.append(",exportModelArtifactDetails=").append(String.valueOf((Object)this.exportModelArtifactDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportModelArtifactRequest)) {
            return false;
        }
        ExportModelArtifactRequest other = (ExportModelArtifactRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.modelId, other.modelId) && Objects.equals((Object)this.exportModelArtifactDetails, (Object)other.exportModelArtifactDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.modelId == null ? 43 : this.modelId.hashCode());
        result = result * 59 + (this.exportModelArtifactDetails == null ? 43 : this.exportModelArtifactDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ExportModelArtifactRequest, ExportModelArtifactDetails> {
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String modelId = null;
        private ExportModelArtifactDetails exportModelArtifactDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String ifMatch = null;

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder exportModelArtifactDetails(ExportModelArtifactDetails exportModelArtifactDetails) {
            this.exportModelArtifactDetails = exportModelArtifactDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ExportModelArtifactRequest o) {
            this.modelId(o.getModelId());
            this.exportModelArtifactDetails(o.getExportModelArtifactDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ExportModelArtifactRequest build() {
            ExportModelArtifactRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ExportModelArtifactDetails body) {
            this.exportModelArtifactDetails(body);
            return this;
        }

        public ExportModelArtifactRequest buildWithoutInvocationCallback() {
            ExportModelArtifactRequest request = new ExportModelArtifactRequest();
            request.modelId = this.modelId;
            request.exportModelArtifactDetails = this.exportModelArtifactDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

