/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.model.Range;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.util.Objects;
import javax.ws.rs.client.Invocation;

public class GetJobArtifactContentRequest
extends BmcRequest<Void> {
    private String jobId;
    private String opcRequestId;
    private Range range;

    public String getJobId() {
        return this.jobId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Range getRange() {
        return this.range;
    }

    public Builder toBuilder() {
        return new Builder().jobId(this.jobId).opcRequestId(this.opcRequestId).range(this.range);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",jobId=").append(String.valueOf(this.jobId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",range=").append(String.valueOf(this.range));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetJobArtifactContentRequest)) {
            return false;
        }
        GetJobArtifactContentRequest other = (GetJobArtifactContentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.jobId, other.jobId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.range, other.range);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.jobId == null ? 43 : this.jobId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.range == null ? 43 : this.range.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetJobArtifactContentRequest, Void> {
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String jobId = null;
        private String opcRequestId = null;
        private Range range = null;

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder range(Range range) {
            this.range = range;
            return this;
        }

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetJobArtifactContentRequest o) {
            this.jobId(o.getJobId());
            this.opcRequestId(o.getOpcRequestId());
            this.range(o.getRange());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetJobArtifactContentRequest build() {
            GetJobArtifactContentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetJobArtifactContentRequest buildWithoutInvocationCallback() {
            GetJobArtifactContentRequest request = new GetJobArtifactContentRequest();
            request.jobId = this.jobId;
            request.opcRequestId = this.opcRequestId;
            request.range = this.range;
            return request;
        }
    }
}

