/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datascience.model.UpdateModelProvenanceDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.util.Objects;
import javax.ws.rs.client.Invocation;

public class UpdateModelProvenanceRequest
extends BmcRequest<UpdateModelProvenanceDetails> {
    private String modelId;
    private UpdateModelProvenanceDetails updateModelProvenanceDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getModelId() {
        return this.modelId;
    }

    public UpdateModelProvenanceDetails getUpdateModelProvenanceDetails() {
        return this.updateModelProvenanceDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateModelProvenanceDetails getBody$() {
        return this.updateModelProvenanceDetails;
    }

    public Builder toBuilder() {
        return new Builder().modelId(this.modelId).updateModelProvenanceDetails(this.updateModelProvenanceDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",modelId=").append(String.valueOf(this.modelId));
        sb.append(",updateModelProvenanceDetails=").append(String.valueOf((Object)this.updateModelProvenanceDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateModelProvenanceRequest)) {
            return false;
        }
        UpdateModelProvenanceRequest other = (UpdateModelProvenanceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.modelId, other.modelId) && Objects.equals((Object)this.updateModelProvenanceDetails, (Object)other.updateModelProvenanceDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.modelId == null ? 43 : this.modelId.hashCode());
        result = result * 59 + (this.updateModelProvenanceDetails == null ? 43 : this.updateModelProvenanceDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateModelProvenanceRequest, UpdateModelProvenanceDetails> {
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String modelId = null;
        private UpdateModelProvenanceDetails updateModelProvenanceDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder updateModelProvenanceDetails(UpdateModelProvenanceDetails updateModelProvenanceDetails) {
            this.updateModelProvenanceDetails = updateModelProvenanceDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateModelProvenanceRequest o) {
            this.modelId(o.getModelId());
            this.updateModelProvenanceDetails(o.getUpdateModelProvenanceDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateModelProvenanceRequest build() {
            UpdateModelProvenanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateModelProvenanceDetails body) {
            this.updateModelProvenanceDetails(body);
            return this;
        }

        public UpdateModelProvenanceRequest buildWithoutInvocationCallback() {
            UpdateModelProvenanceRequest request = new UpdateModelProvenanceRequest();
            request.modelId = this.modelId;
            request.updateModelProvenanceDetails = this.updateModelProvenanceDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

