/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datascience.model.UpdateModelDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.util.Objects;
import javax.ws.rs.client.Invocation;

public class UpdateModelRequest
extends BmcRequest<UpdateModelDetails> {
    private String modelId;
    private UpdateModelDetails updateModelDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getModelId() {
        return this.modelId;
    }

    public UpdateModelDetails getUpdateModelDetails() {
        return this.updateModelDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateModelDetails getBody$() {
        return this.updateModelDetails;
    }

    public Builder toBuilder() {
        return new Builder().modelId(this.modelId).updateModelDetails(this.updateModelDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",modelId=").append(String.valueOf(this.modelId));
        sb.append(",updateModelDetails=").append(String.valueOf((Object)this.updateModelDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateModelRequest)) {
            return false;
        }
        UpdateModelRequest other = (UpdateModelRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.modelId, other.modelId) && Objects.equals((Object)this.updateModelDetails, (Object)other.updateModelDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.modelId == null ? 43 : this.modelId.hashCode());
        result = result * 59 + (this.updateModelDetails == null ? 43 : this.updateModelDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateModelRequest, UpdateModelDetails> {
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String modelId = null;
        private UpdateModelDetails updateModelDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder updateModelDetails(UpdateModelDetails updateModelDetails) {
            this.updateModelDetails = updateModelDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateModelRequest o) {
            this.modelId(o.getModelId());
            this.updateModelDetails(o.getUpdateModelDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateModelRequest build() {
            UpdateModelRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateModelDetails body) {
            this.updateModelDetails(body);
            return this;
        }

        public UpdateModelRequest buildWithoutInvocationCallback() {
            UpdateModelRequest request = new UpdateModelRequest();
            request.modelId = this.modelId;
            request.updateModelDetails = this.updateModelDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

