/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience;

import com.oracle.bmc.datascience.DataScience;
import com.oracle.bmc.datascience.model.JobLifecycleState;
import com.oracle.bmc.datascience.model.JobRunLifecycleState;
import com.oracle.bmc.datascience.model.ModelDeploymentLifecycleState;
import com.oracle.bmc.datascience.model.ModelLifecycleState;
import com.oracle.bmc.datascience.model.ModelVersionSetLifecycleState;
import com.oracle.bmc.datascience.model.NotebookSessionLifecycleState;
import com.oracle.bmc.datascience.model.PipelineLifecycleState;
import com.oracle.bmc.datascience.model.PipelineRunLifecycleState;
import com.oracle.bmc.datascience.model.ProjectLifecycleState;
import com.oracle.bmc.datascience.requests.GetJobRequest;
import com.oracle.bmc.datascience.requests.GetJobRunRequest;
import com.oracle.bmc.datascience.requests.GetModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.GetModelRequest;
import com.oracle.bmc.datascience.requests.GetModelVersionSetRequest;
import com.oracle.bmc.datascience.requests.GetNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.GetPipelineRequest;
import com.oracle.bmc.datascience.requests.GetPipelineRunRequest;
import com.oracle.bmc.datascience.requests.GetProjectRequest;
import com.oracle.bmc.datascience.requests.GetWorkRequestRequest;
import com.oracle.bmc.datascience.responses.GetJobResponse;
import com.oracle.bmc.datascience.responses.GetJobRunResponse;
import com.oracle.bmc.datascience.responses.GetModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.GetModelResponse;
import com.oracle.bmc.datascience.responses.GetModelVersionSetResponse;
import com.oracle.bmc.datascience.responses.GetNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.GetPipelineResponse;
import com.oracle.bmc.datascience.responses.GetPipelineRunResponse;
import com.oracle.bmc.datascience.responses.GetProjectResponse;
import com.oracle.bmc.datascience.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class DataScienceWaiters {
    private final ExecutorService executorService;
    private final DataScience client;

    public DataScienceWaiters(ExecutorService executorService, DataScience client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetJobRequest, GetJobResponse> forJob(GetJobRequest request, JobLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJob(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetJobRequest, GetJobResponse> forJob(GetJobRequest request, JobLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetJobRequest, GetJobResponse> forJob(GetJobRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, JobLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetJobRequest, GetJobResponse> forJob(BmcGenericWaiter waiter, GetJobRequest request, JobLifecycleState ... targetStates) {
        final HashSet<JobLifecycleState> targetStatesSet = new HashSet<JobLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetJobRequest, GetJobResponse>(){

            @Override
            public GetJobResponse apply(GetJobRequest request) {
                return DataScienceWaiters.this.client.getJob(request);
            }
        }, (Predicate)new Predicate<GetJobResponse>(){

            @Override
            public boolean test(GetJobResponse response) {
                return targetStatesSet.contains((Object)response.getJob().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)JobLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetJobRunRequest, GetJobRunResponse> forJobRun(GetJobRunRequest request, JobRunLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJobRun(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetJobRunRequest, GetJobRunResponse> forJobRun(GetJobRunRequest request, JobRunLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forJobRun(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetJobRunRequest, GetJobRunResponse> forJobRun(GetJobRunRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, JobRunLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJobRun(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetJobRunRequest, GetJobRunResponse> forJobRun(BmcGenericWaiter waiter, GetJobRunRequest request, JobRunLifecycleState ... targetStates) {
        final HashSet<JobRunLifecycleState> targetStatesSet = new HashSet<JobRunLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetJobRunRequest, GetJobRunResponse>(){

            @Override
            public GetJobRunResponse apply(GetJobRunRequest request) {
                return DataScienceWaiters.this.client.getJobRun(request);
            }
        }, (Predicate)new Predicate<GetJobRunResponse>(){

            @Override
            public boolean test(GetJobRunResponse response) {
                return targetStatesSet.contains((Object)response.getJobRun().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)JobRunLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetModelRequest, GetModelResponse> forModel(GetModelRequest request, ModelLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forModel(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetModelRequest, GetModelResponse> forModel(GetModelRequest request, ModelLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forModel(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetModelRequest, GetModelResponse> forModel(GetModelRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ModelLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forModel(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetModelRequest, GetModelResponse> forModel(BmcGenericWaiter waiter, GetModelRequest request, ModelLifecycleState ... targetStates) {
        final HashSet<ModelLifecycleState> targetStatesSet = new HashSet<ModelLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetModelRequest, GetModelResponse>(){

            @Override
            public GetModelResponse apply(GetModelRequest request) {
                return DataScienceWaiters.this.client.getModel(request);
            }
        }, (Predicate)new Predicate<GetModelResponse>(){

            @Override
            public boolean test(GetModelResponse response) {
                return targetStatesSet.contains((Object)response.getModel().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ModelLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetModelDeploymentRequest, GetModelDeploymentResponse> forModelDeployment(GetModelDeploymentRequest request, ModelDeploymentLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forModelDeployment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetModelDeploymentRequest, GetModelDeploymentResponse> forModelDeployment(GetModelDeploymentRequest request, ModelDeploymentLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forModelDeployment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetModelDeploymentRequest, GetModelDeploymentResponse> forModelDeployment(GetModelDeploymentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ModelDeploymentLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forModelDeployment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetModelDeploymentRequest, GetModelDeploymentResponse> forModelDeployment(BmcGenericWaiter waiter, GetModelDeploymentRequest request, ModelDeploymentLifecycleState ... targetStates) {
        final HashSet<ModelDeploymentLifecycleState> targetStatesSet = new HashSet<ModelDeploymentLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetModelDeploymentRequest, GetModelDeploymentResponse>(){

            @Override
            public GetModelDeploymentResponse apply(GetModelDeploymentRequest request) {
                return DataScienceWaiters.this.client.getModelDeployment(request);
            }
        }, (Predicate)new Predicate<GetModelDeploymentResponse>(){

            @Override
            public boolean test(GetModelDeploymentResponse response) {
                return targetStatesSet.contains((Object)response.getModelDeployment().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ModelDeploymentLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetModelVersionSetRequest, GetModelVersionSetResponse> forModelVersionSet(GetModelVersionSetRequest request, ModelVersionSetLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forModelVersionSet(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetModelVersionSetRequest, GetModelVersionSetResponse> forModelVersionSet(GetModelVersionSetRequest request, ModelVersionSetLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forModelVersionSet(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetModelVersionSetRequest, GetModelVersionSetResponse> forModelVersionSet(GetModelVersionSetRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ModelVersionSetLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forModelVersionSet(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetModelVersionSetRequest, GetModelVersionSetResponse> forModelVersionSet(BmcGenericWaiter waiter, GetModelVersionSetRequest request, ModelVersionSetLifecycleState ... targetStates) {
        final HashSet<ModelVersionSetLifecycleState> targetStatesSet = new HashSet<ModelVersionSetLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetModelVersionSetRequest, GetModelVersionSetResponse>(){

            @Override
            public GetModelVersionSetResponse apply(GetModelVersionSetRequest request) {
                return DataScienceWaiters.this.client.getModelVersionSet(request);
            }
        }, (Predicate)new Predicate<GetModelVersionSetResponse>(){

            @Override
            public boolean test(GetModelVersionSetResponse response) {
                return targetStatesSet.contains((Object)response.getModelVersionSet().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ModelVersionSetLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetNotebookSessionRequest, GetNotebookSessionResponse> forNotebookSession(GetNotebookSessionRequest request, NotebookSessionLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNotebookSession(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetNotebookSessionRequest, GetNotebookSessionResponse> forNotebookSession(GetNotebookSessionRequest request, NotebookSessionLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forNotebookSession(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetNotebookSessionRequest, GetNotebookSessionResponse> forNotebookSession(GetNotebookSessionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, NotebookSessionLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNotebookSession(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetNotebookSessionRequest, GetNotebookSessionResponse> forNotebookSession(BmcGenericWaiter waiter, GetNotebookSessionRequest request, NotebookSessionLifecycleState ... targetStates) {
        final HashSet<NotebookSessionLifecycleState> targetStatesSet = new HashSet<NotebookSessionLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetNotebookSessionRequest, GetNotebookSessionResponse>(){

            @Override
            public GetNotebookSessionResponse apply(GetNotebookSessionRequest request) {
                return DataScienceWaiters.this.client.getNotebookSession(request);
            }
        }, (Predicate)new Predicate<GetNotebookSessionResponse>(){

            @Override
            public boolean test(GetNotebookSessionResponse response) {
                return targetStatesSet.contains((Object)response.getNotebookSession().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)NotebookSessionLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetPipelineRequest, GetPipelineResponse> forPipeline(GetPipelineRequest request, PipelineLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPipeline(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetPipelineRequest, GetPipelineResponse> forPipeline(GetPipelineRequest request, PipelineLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forPipeline(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetPipelineRequest, GetPipelineResponse> forPipeline(GetPipelineRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, PipelineLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPipeline(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetPipelineRequest, GetPipelineResponse> forPipeline(BmcGenericWaiter waiter, GetPipelineRequest request, PipelineLifecycleState ... targetStates) {
        final HashSet<PipelineLifecycleState> targetStatesSet = new HashSet<PipelineLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetPipelineRequest, GetPipelineResponse>(){

            @Override
            public GetPipelineResponse apply(GetPipelineRequest request) {
                return DataScienceWaiters.this.client.getPipeline(request);
            }
        }, (Predicate)new Predicate<GetPipelineResponse>(){

            @Override
            public boolean test(GetPipelineResponse response) {
                return targetStatesSet.contains((Object)response.getPipeline().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)PipelineLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetPipelineRunRequest, GetPipelineRunResponse> forPipelineRun(GetPipelineRunRequest request, PipelineRunLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPipelineRun(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetPipelineRunRequest, GetPipelineRunResponse> forPipelineRun(GetPipelineRunRequest request, PipelineRunLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forPipelineRun(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetPipelineRunRequest, GetPipelineRunResponse> forPipelineRun(GetPipelineRunRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, PipelineRunLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPipelineRun(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetPipelineRunRequest, GetPipelineRunResponse> forPipelineRun(BmcGenericWaiter waiter, GetPipelineRunRequest request, PipelineRunLifecycleState ... targetStates) {
        final HashSet<PipelineRunLifecycleState> targetStatesSet = new HashSet<PipelineRunLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetPipelineRunRequest, GetPipelineRunResponse>(){

            @Override
            public GetPipelineRunResponse apply(GetPipelineRunRequest request) {
                return DataScienceWaiters.this.client.getPipelineRun(request);
            }
        }, (Predicate)new Predicate<GetPipelineRunResponse>(){

            @Override
            public boolean test(GetPipelineRunResponse response) {
                return targetStatesSet.contains((Object)response.getPipelineRun().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)PipelineRunLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetProjectRequest, GetProjectResponse> forProject(GetProjectRequest request, ProjectLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forProject(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetProjectRequest, GetProjectResponse> forProject(GetProjectRequest request, ProjectLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forProject(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetProjectRequest, GetProjectResponse> forProject(GetProjectRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ProjectLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forProject(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetProjectRequest, GetProjectResponse> forProject(BmcGenericWaiter waiter, GetProjectRequest request, ProjectLifecycleState ... targetStates) {
        final HashSet<ProjectLifecycleState> targetStatesSet = new HashSet<ProjectLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetProjectRequest, GetProjectResponse>(){

            @Override
            public GetProjectResponse apply(GetProjectRequest request) {
                return DataScienceWaiters.this.client.getProject(request);
            }
        }, (Predicate)new Predicate<GetProjectResponse>(){

            @Override
            public boolean test(GetProjectResponse response) {
                return targetStatesSet.contains((Object)response.getProject().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ProjectLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return DataScienceWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

