/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PipelineStepConfigurationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="maximumRuntimeInMinutes")
    private final Long maximumRuntimeInMinutes;
    @JsonProperty(value="environmentVariables")
    private final Map<String, String> environmentVariables;
    @JsonProperty(value="commandLineArguments")
    private final String commandLineArguments;

    @Deprecated
    @ConstructorProperties(value={"maximumRuntimeInMinutes", "environmentVariables", "commandLineArguments"})
    public PipelineStepConfigurationDetails(Long maximumRuntimeInMinutes, Map<String, String> environmentVariables, String commandLineArguments) {
        this.maximumRuntimeInMinutes = maximumRuntimeInMinutes;
        this.environmentVariables = environmentVariables;
        this.commandLineArguments = commandLineArguments;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getMaximumRuntimeInMinutes() {
        return this.maximumRuntimeInMinutes;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public String getCommandLineArguments() {
        return this.commandLineArguments;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PipelineStepConfigurationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("maximumRuntimeInMinutes=").append(String.valueOf(this.maximumRuntimeInMinutes));
        sb.append(", environmentVariables=").append(String.valueOf(this.environmentVariables));
        sb.append(", commandLineArguments=").append(String.valueOf(this.commandLineArguments));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PipelineStepConfigurationDetails)) {
            return false;
        }
        PipelineStepConfigurationDetails other = (PipelineStepConfigurationDetails)((Object)o);
        return Objects.equals(this.maximumRuntimeInMinutes, other.maximumRuntimeInMinutes) && Objects.equals(this.environmentVariables, other.environmentVariables) && Objects.equals(this.commandLineArguments, other.commandLineArguments) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.maximumRuntimeInMinutes == null ? 43 : this.maximumRuntimeInMinutes.hashCode());
        result = result * 59 + (this.environmentVariables == null ? 43 : this.environmentVariables.hashCode());
        result = result * 59 + (this.commandLineArguments == null ? 43 : this.commandLineArguments.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="maximumRuntimeInMinutes")
        private Long maximumRuntimeInMinutes;
        @JsonProperty(value="environmentVariables")
        private Map<String, String> environmentVariables;
        @JsonProperty(value="commandLineArguments")
        private String commandLineArguments;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder maximumRuntimeInMinutes(Long maximumRuntimeInMinutes) {
            this.maximumRuntimeInMinutes = maximumRuntimeInMinutes;
            this.__explicitlySet__.add("maximumRuntimeInMinutes");
            return this;
        }

        public Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            this.__explicitlySet__.add("environmentVariables");
            return this;
        }

        public Builder commandLineArguments(String commandLineArguments) {
            this.commandLineArguments = commandLineArguments;
            this.__explicitlySet__.add("commandLineArguments");
            return this;
        }

        public PipelineStepConfigurationDetails build() {
            PipelineStepConfigurationDetails model = new PipelineStepConfigurationDetails(this.maximumRuntimeInMinutes, this.environmentVariables, this.commandLineArguments);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PipelineStepConfigurationDetails model) {
            if (model.wasPropertyExplicitlySet("maximumRuntimeInMinutes")) {
                this.maximumRuntimeInMinutes(model.getMaximumRuntimeInMinutes());
            }
            if (model.wasPropertyExplicitlySet("environmentVariables")) {
                this.environmentVariables(model.getEnvironmentVariables());
            }
            if (model.wasPropertyExplicitlySet("commandLineArguments")) {
                this.commandLineArguments(model.getCommandLineArguments());
            }
            return this;
        }
    }
}

