/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.requests.HasContentLength;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.io.InputStream;
import java.util.Objects;

public class CreateJobArtifactRequest
extends BmcRequest<InputStream>
implements HasContentLength {
    private String jobId;
    private Long contentLength;
    private InputStream jobArtifact;
    private String opcRequestId;
    private String opcRetryToken;
    private String contentDisposition;

    public String getJobId() {
        return this.jobId;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public InputStream getJobArtifact() {
        return this.jobArtifact;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    @InternalSdk
    public InputStream getBody$() {
        return this.jobArtifact;
    }

    public Builder toBuilder() {
        return new Builder().jobId(this.jobId).contentLength(this.contentLength).jobArtifact(this.jobArtifact).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).contentDisposition(this.contentDisposition);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",jobId=").append(String.valueOf(this.jobId));
        sb.append(",contentLength=").append(String.valueOf(this.contentLength));
        sb.append(",jobArtifact=").append(String.valueOf(this.jobArtifact));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",contentDisposition=").append(String.valueOf(this.contentDisposition));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateJobArtifactRequest)) {
            return false;
        }
        CreateJobArtifactRequest other = (CreateJobArtifactRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.jobId, other.jobId) && Objects.equals(this.contentLength, other.contentLength) && Objects.equals(this.jobArtifact, other.jobArtifact) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.contentDisposition, other.contentDisposition);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.jobId == null ? 43 : this.jobId.hashCode());
        result = result * 59 + (this.contentLength == null ? 43 : this.contentLength.hashCode());
        result = result * 59 + (this.jobArtifact == null ? 43 : this.jobArtifact.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.contentDisposition == null ? 43 : this.contentDisposition.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateJobArtifactRequest, InputStream> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String jobId = null;
        private Long contentLength = null;
        private InputStream jobArtifact = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String contentDisposition = null;

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public Builder jobArtifact(InputStream jobArtifact) {
            this.jobArtifact = jobArtifact;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateJobArtifactRequest o) {
            this.jobId(o.getJobId());
            this.contentLength(o.getContentLength());
            this.jobArtifact(o.getJobArtifact());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.contentDisposition(o.getContentDisposition());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateJobArtifactRequest build() {
            CreateJobArtifactRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.jobArtifact(body);
            return this;
        }

        public CreateJobArtifactRequest buildWithoutInvocationCallback() {
            CreateJobArtifactRequest request = new CreateJobArtifactRequest();
            request.jobId = this.jobId;
            request.contentLength = this.contentLength;
            request.jobArtifact = this.jobArtifact;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.contentDisposition = this.contentDisposition;
            return request;
        }
    }
}

