/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datascience.model.ImportModelArtifactDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ImportModelArtifactRequest
extends BmcRequest<ImportModelArtifactDetails> {
    private String modelId;
    private ImportModelArtifactDetails importModelArtifactDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getModelId() {
        return this.modelId;
    }

    public ImportModelArtifactDetails getImportModelArtifactDetails() {
        return this.importModelArtifactDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public ImportModelArtifactDetails getBody$() {
        return this.importModelArtifactDetails;
    }

    public Builder toBuilder() {
        return new Builder().modelId(this.modelId).importModelArtifactDetails(this.importModelArtifactDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",modelId=").append(String.valueOf(this.modelId));
        sb.append(",importModelArtifactDetails=").append(String.valueOf((Object)this.importModelArtifactDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImportModelArtifactRequest)) {
            return false;
        }
        ImportModelArtifactRequest other = (ImportModelArtifactRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.modelId, other.modelId) && Objects.equals((Object)this.importModelArtifactDetails, (Object)other.importModelArtifactDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.modelId == null ? 43 : this.modelId.hashCode());
        result = result * 59 + (this.importModelArtifactDetails == null ? 43 : this.importModelArtifactDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ImportModelArtifactRequest, ImportModelArtifactDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String modelId = null;
        private ImportModelArtifactDetails importModelArtifactDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder importModelArtifactDetails(ImportModelArtifactDetails importModelArtifactDetails) {
            this.importModelArtifactDetails = importModelArtifactDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ImportModelArtifactRequest o) {
            this.modelId(o.getModelId());
            this.importModelArtifactDetails(o.getImportModelArtifactDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ImportModelArtifactRequest build() {
            ImportModelArtifactRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ImportModelArtifactDetails body) {
            this.importModelArtifactDetails(body);
            return this;
        }

        public ImportModelArtifactRequest buildWithoutInvocationCallback() {
            ImportModelArtifactRequest request = new ImportModelArtifactRequest();
            request.modelId = this.modelId;
            request.importModelArtifactDetails = this.importModelArtifactDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

