/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datascience.model.UpdatePipelineDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdatePipelineRequest
extends BmcRequest<UpdatePipelineDetails> {
    private String pipelineId;
    private UpdatePipelineDetails updatePipelineDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getPipelineId() {
        return this.pipelineId;
    }

    public UpdatePipelineDetails getUpdatePipelineDetails() {
        return this.updatePipelineDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdatePipelineDetails getBody$() {
        return this.updatePipelineDetails;
    }

    public Builder toBuilder() {
        return new Builder().pipelineId(this.pipelineId).updatePipelineDetails(this.updatePipelineDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",pipelineId=").append(String.valueOf(this.pipelineId));
        sb.append(",updatePipelineDetails=").append(String.valueOf((Object)this.updatePipelineDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdatePipelineRequest)) {
            return false;
        }
        UpdatePipelineRequest other = (UpdatePipelineRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.pipelineId, other.pipelineId) && Objects.equals((Object)this.updatePipelineDetails, (Object)other.updatePipelineDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pipelineId == null ? 43 : this.pipelineId.hashCode());
        result = result * 59 + (this.updatePipelineDetails == null ? 43 : this.updatePipelineDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdatePipelineRequest, UpdatePipelineDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String pipelineId = null;
        private UpdatePipelineDetails updatePipelineDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public Builder updatePipelineDetails(UpdatePipelineDetails updatePipelineDetails) {
            this.updatePipelineDetails = updatePipelineDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdatePipelineRequest o) {
            this.pipelineId(o.getPipelineId());
            this.updatePipelineDetails(o.getUpdatePipelineDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdatePipelineRequest build() {
            UpdatePipelineRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdatePipelineDetails body) {
            this.updatePipelineDetails(body);
            return this;
        }

        public UpdatePipelineRequest buildWithoutInvocationCallback() {
            UpdatePipelineRequest request = new UpdatePipelineRequest();
            request.pipelineId = this.pipelineId;
            request.updatePipelineDetails = this.updatePipelineDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

