/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datascience.model.JobConfigurationDetails;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="jobType")
@JsonFilter(value="explicitlySetFilter")
public final class DefaultJobConfigurationDetails
extends JobConfigurationDetails {
    @JsonProperty(value="environmentVariables")
    private final Map<String, String> environmentVariables;
    @JsonProperty(value="commandLineArguments")
    private final String commandLineArguments;
    @JsonProperty(value="maximumRuntimeInMinutes")
    private final Long maximumRuntimeInMinutes;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DefaultJobConfigurationDetails(Map<String, String> environmentVariables, String commandLineArguments, Long maximumRuntimeInMinutes) {
        this.environmentVariables = environmentVariables;
        this.commandLineArguments = commandLineArguments;
        this.maximumRuntimeInMinutes = maximumRuntimeInMinutes;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public String getCommandLineArguments() {
        return this.commandLineArguments;
    }

    public Long getMaximumRuntimeInMinutes() {
        return this.maximumRuntimeInMinutes;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DefaultJobConfigurationDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", environmentVariables=").append(String.valueOf(this.environmentVariables));
        sb.append(", commandLineArguments=").append(String.valueOf(this.commandLineArguments));
        sb.append(", maximumRuntimeInMinutes=").append(String.valueOf(this.maximumRuntimeInMinutes));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultJobConfigurationDetails)) {
            return false;
        }
        DefaultJobConfigurationDetails other = (DefaultJobConfigurationDetails)((Object)o);
        return Objects.equals(this.environmentVariables, other.environmentVariables) && Objects.equals(this.commandLineArguments, other.commandLineArguments) && Objects.equals(this.maximumRuntimeInMinutes, other.maximumRuntimeInMinutes) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.environmentVariables == null ? 43 : this.environmentVariables.hashCode());
        result = result * 59 + (this.commandLineArguments == null ? 43 : this.commandLineArguments.hashCode());
        result = result * 59 + (this.maximumRuntimeInMinutes == null ? 43 : this.maximumRuntimeInMinutes.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="environmentVariables")
        private Map<String, String> environmentVariables;
        @JsonProperty(value="commandLineArguments")
        private String commandLineArguments;
        @JsonProperty(value="maximumRuntimeInMinutes")
        private Long maximumRuntimeInMinutes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            this.__explicitlySet__.add("environmentVariables");
            return this;
        }

        public Builder commandLineArguments(String commandLineArguments) {
            this.commandLineArguments = commandLineArguments;
            this.__explicitlySet__.add("commandLineArguments");
            return this;
        }

        public Builder maximumRuntimeInMinutes(Long maximumRuntimeInMinutes) {
            this.maximumRuntimeInMinutes = maximumRuntimeInMinutes;
            this.__explicitlySet__.add("maximumRuntimeInMinutes");
            return this;
        }

        public DefaultJobConfigurationDetails build() {
            DefaultJobConfigurationDetails model = new DefaultJobConfigurationDetails(this.environmentVariables, this.commandLineArguments, this.maximumRuntimeInMinutes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DefaultJobConfigurationDetails model) {
            if (model.wasPropertyExplicitlySet("environmentVariables")) {
                this.environmentVariables(model.getEnvironmentVariables());
            }
            if (model.wasPropertyExplicitlySet("commandLineArguments")) {
                this.commandLineArguments(model.getCommandLineArguments());
            }
            if (model.wasPropertyExplicitlySet("maximumRuntimeInMinutes")) {
                this.maximumRuntimeInMinutes(model.getMaximumRuntimeInMinutes());
            }
            return this;
        }
    }
}

