/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datascience.model.ModelDeploymentEnvironmentConfigurationDetails;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="environmentConfigurationType")
@JsonFilter(value="explicitlySetFilter")
public final class OcirModelDeploymentEnvironmentConfigurationDetails
extends ModelDeploymentEnvironmentConfigurationDetails {
    @JsonProperty(value="image")
    private final String image;
    @JsonProperty(value="imageDigest")
    private final String imageDigest;
    @JsonProperty(value="cmd")
    private final List<String> cmd;
    @JsonProperty(value="entrypoint")
    private final List<String> entrypoint;
    @JsonProperty(value="serverPort")
    private final Integer serverPort;
    @JsonProperty(value="healthCheckPort")
    private final Integer healthCheckPort;
    @JsonProperty(value="environmentVariables")
    private final Map<String, String> environmentVariables;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public OcirModelDeploymentEnvironmentConfigurationDetails(String image, String imageDigest, List<String> cmd, List<String> entrypoint, Integer serverPort, Integer healthCheckPort, Map<String, String> environmentVariables) {
        this.image = image;
        this.imageDigest = imageDigest;
        this.cmd = cmd;
        this.entrypoint = entrypoint;
        this.serverPort = serverPort;
        this.healthCheckPort = healthCheckPort;
        this.environmentVariables = environmentVariables;
    }

    public String getImage() {
        return this.image;
    }

    public String getImageDigest() {
        return this.imageDigest;
    }

    public List<String> getCmd() {
        return this.cmd;
    }

    public List<String> getEntrypoint() {
        return this.entrypoint;
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public Integer getHealthCheckPort() {
        return this.healthCheckPort;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OcirModelDeploymentEnvironmentConfigurationDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", image=").append(String.valueOf(this.image));
        sb.append(", imageDigest=").append(String.valueOf(this.imageDigest));
        sb.append(", cmd=").append(String.valueOf(this.cmd));
        sb.append(", entrypoint=").append(String.valueOf(this.entrypoint));
        sb.append(", serverPort=").append(String.valueOf(this.serverPort));
        sb.append(", healthCheckPort=").append(String.valueOf(this.healthCheckPort));
        sb.append(", environmentVariables=").append(String.valueOf(this.environmentVariables));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OcirModelDeploymentEnvironmentConfigurationDetails)) {
            return false;
        }
        OcirModelDeploymentEnvironmentConfigurationDetails other = (OcirModelDeploymentEnvironmentConfigurationDetails)((Object)o);
        return Objects.equals(this.image, other.image) && Objects.equals(this.imageDigest, other.imageDigest) && Objects.equals(this.cmd, other.cmd) && Objects.equals(this.entrypoint, other.entrypoint) && Objects.equals(this.serverPort, other.serverPort) && Objects.equals(this.healthCheckPort, other.healthCheckPort) && Objects.equals(this.environmentVariables, other.environmentVariables) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.image == null ? 43 : this.image.hashCode());
        result = result * 59 + (this.imageDigest == null ? 43 : this.imageDigest.hashCode());
        result = result * 59 + (this.cmd == null ? 43 : this.cmd.hashCode());
        result = result * 59 + (this.entrypoint == null ? 43 : this.entrypoint.hashCode());
        result = result * 59 + (this.serverPort == null ? 43 : this.serverPort.hashCode());
        result = result * 59 + (this.healthCheckPort == null ? 43 : this.healthCheckPort.hashCode());
        result = result * 59 + (this.environmentVariables == null ? 43 : this.environmentVariables.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="image")
        private String image;
        @JsonProperty(value="imageDigest")
        private String imageDigest;
        @JsonProperty(value="cmd")
        private List<String> cmd;
        @JsonProperty(value="entrypoint")
        private List<String> entrypoint;
        @JsonProperty(value="serverPort")
        private Integer serverPort;
        @JsonProperty(value="healthCheckPort")
        private Integer healthCheckPort;
        @JsonProperty(value="environmentVariables")
        private Map<String, String> environmentVariables;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder image(String image) {
            this.image = image;
            this.__explicitlySet__.add("image");
            return this;
        }

        public Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            this.__explicitlySet__.add("imageDigest");
            return this;
        }

        public Builder cmd(List<String> cmd) {
            this.cmd = cmd;
            this.__explicitlySet__.add("cmd");
            return this;
        }

        public Builder entrypoint(List<String> entrypoint) {
            this.entrypoint = entrypoint;
            this.__explicitlySet__.add("entrypoint");
            return this;
        }

        public Builder serverPort(Integer serverPort) {
            this.serverPort = serverPort;
            this.__explicitlySet__.add("serverPort");
            return this;
        }

        public Builder healthCheckPort(Integer healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
            this.__explicitlySet__.add("healthCheckPort");
            return this;
        }

        public Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            this.__explicitlySet__.add("environmentVariables");
            return this;
        }

        public OcirModelDeploymentEnvironmentConfigurationDetails build() {
            OcirModelDeploymentEnvironmentConfigurationDetails model = new OcirModelDeploymentEnvironmentConfigurationDetails(this.image, this.imageDigest, this.cmd, this.entrypoint, this.serverPort, this.healthCheckPort, this.environmentVariables);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OcirModelDeploymentEnvironmentConfigurationDetails model) {
            if (model.wasPropertyExplicitlySet("image")) {
                this.image(model.getImage());
            }
            if (model.wasPropertyExplicitlySet("imageDigest")) {
                this.imageDigest(model.getImageDigest());
            }
            if (model.wasPropertyExplicitlySet("cmd")) {
                this.cmd(model.getCmd());
            }
            if (model.wasPropertyExplicitlySet("entrypoint")) {
                this.entrypoint(model.getEntrypoint());
            }
            if (model.wasPropertyExplicitlySet("serverPort")) {
                this.serverPort(model.getServerPort());
            }
            if (model.wasPropertyExplicitlySet("healthCheckPort")) {
                this.healthCheckPort(model.getHealthCheckPort());
            }
            if (model.wasPropertyExplicitlySet("environmentVariables")) {
                this.environmentVariables(model.getEnvironmentVariables());
            }
            return this;
        }
    }
}

