/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datascience.model.PipelineShapeConfigDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PipelineInfrastructureConfigurationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="shapeName")
    private final String shapeName;
    @JsonProperty(value="blockStorageSizeInGBs")
    private final Integer blockStorageSizeInGBs;
    @JsonProperty(value="shapeConfigDetails")
    private final PipelineShapeConfigDetails shapeConfigDetails;

    @Deprecated
    @ConstructorProperties(value={"shapeName", "blockStorageSizeInGBs", "shapeConfigDetails"})
    public PipelineInfrastructureConfigurationDetails(String shapeName, Integer blockStorageSizeInGBs, PipelineShapeConfigDetails shapeConfigDetails) {
        this.shapeName = shapeName;
        this.blockStorageSizeInGBs = blockStorageSizeInGBs;
        this.shapeConfigDetails = shapeConfigDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getShapeName() {
        return this.shapeName;
    }

    public Integer getBlockStorageSizeInGBs() {
        return this.blockStorageSizeInGBs;
    }

    public PipelineShapeConfigDetails getShapeConfigDetails() {
        return this.shapeConfigDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PipelineInfrastructureConfigurationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("shapeName=").append(String.valueOf(this.shapeName));
        sb.append(", blockStorageSizeInGBs=").append(String.valueOf(this.blockStorageSizeInGBs));
        sb.append(", shapeConfigDetails=").append(String.valueOf((Object)this.shapeConfigDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PipelineInfrastructureConfigurationDetails)) {
            return false;
        }
        PipelineInfrastructureConfigurationDetails other = (PipelineInfrastructureConfigurationDetails)((Object)o);
        return Objects.equals(this.shapeName, other.shapeName) && Objects.equals(this.blockStorageSizeInGBs, other.blockStorageSizeInGBs) && Objects.equals((Object)this.shapeConfigDetails, (Object)other.shapeConfigDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.shapeName == null ? 43 : this.shapeName.hashCode());
        result = result * 59 + (this.blockStorageSizeInGBs == null ? 43 : this.blockStorageSizeInGBs.hashCode());
        result = result * 59 + (this.shapeConfigDetails == null ? 43 : this.shapeConfigDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="shapeName")
        private String shapeName;
        @JsonProperty(value="blockStorageSizeInGBs")
        private Integer blockStorageSizeInGBs;
        @JsonProperty(value="shapeConfigDetails")
        private PipelineShapeConfigDetails shapeConfigDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder shapeName(String shapeName) {
            this.shapeName = shapeName;
            this.__explicitlySet__.add("shapeName");
            return this;
        }

        public Builder blockStorageSizeInGBs(Integer blockStorageSizeInGBs) {
            this.blockStorageSizeInGBs = blockStorageSizeInGBs;
            this.__explicitlySet__.add("blockStorageSizeInGBs");
            return this;
        }

        public Builder shapeConfigDetails(PipelineShapeConfigDetails shapeConfigDetails) {
            this.shapeConfigDetails = shapeConfigDetails;
            this.__explicitlySet__.add("shapeConfigDetails");
            return this;
        }

        public PipelineInfrastructureConfigurationDetails build() {
            PipelineInfrastructureConfigurationDetails model = new PipelineInfrastructureConfigurationDetails(this.shapeName, this.blockStorageSizeInGBs, this.shapeConfigDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PipelineInfrastructureConfigurationDetails model) {
            if (model.wasPropertyExplicitlySet("shapeName")) {
                this.shapeName(model.getShapeName());
            }
            if (model.wasPropertyExplicitlySet("blockStorageSizeInGBs")) {
                this.blockStorageSizeInGBs(model.getBlockStorageSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("shapeConfigDetails")) {
                this.shapeConfigDetails(model.getShapeConfigDetails());
            }
            return this;
        }
    }
}

