/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datascience.model.PipelineCustomScriptStepDetails;
import com.oracle.bmc.datascience.model.PipelineMLJobStepDetails;
import com.oracle.bmc.datascience.model.PipelineStepConfigurationDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="stepType", defaultImpl=PipelineStepDetails.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=PipelineMLJobStepDetails.class, name="ML_JOB"), @JsonSubTypes.Type(value=PipelineCustomScriptStepDetails.class, name="CUSTOM_SCRIPT")})
@JsonFilter(value="explicitlySetFilter")
public class PipelineStepDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="stepName")
    private final String stepName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="dependsOn")
    private final List<String> dependsOn;
    @JsonProperty(value="stepConfigurationDetails")
    private final PipelineStepConfigurationDetails stepConfigurationDetails;

    @Deprecated
    @ConstructorProperties(value={"stepName", "description", "dependsOn", "stepConfigurationDetails"})
    protected PipelineStepDetails(String stepName, String description, List<String> dependsOn, PipelineStepConfigurationDetails stepConfigurationDetails) {
        this.stepName = stepName;
        this.description = description;
        this.dependsOn = dependsOn;
        this.stepConfigurationDetails = stepConfigurationDetails;
    }

    public String getStepName() {
        return this.stepName;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getDependsOn() {
        return this.dependsOn;
    }

    public PipelineStepConfigurationDetails getStepConfigurationDetails() {
        return this.stepConfigurationDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PipelineStepDetails(");
        sb.append("super=").append(super.toString());
        sb.append("stepName=").append(String.valueOf(this.stepName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", dependsOn=").append(String.valueOf(this.dependsOn));
        sb.append(", stepConfigurationDetails=").append(String.valueOf((Object)this.stepConfigurationDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PipelineStepDetails)) {
            return false;
        }
        PipelineStepDetails other = (PipelineStepDetails)((Object)o);
        return Objects.equals(this.stepName, other.stepName) && Objects.equals(this.description, other.description) && Objects.equals(this.dependsOn, other.dependsOn) && Objects.equals((Object)this.stepConfigurationDetails, (Object)other.stepConfigurationDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.stepName == null ? 43 : this.stepName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.dependsOn == null ? 43 : this.dependsOn.hashCode());
        result = result * 59 + (this.stepConfigurationDetails == null ? 43 : this.stepConfigurationDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum StepType implements BmcEnum
    {
        MlJob("ML_JOB"),
        CustomScript("CUSTOM_SCRIPT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, StepType> map;

        private StepType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static StepType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'StepType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(StepType.class);
            map = new HashMap<String, StepType>();
            for (StepType v : StepType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

