/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datascience.model.FileStorageMountConfigurationDetails;
import com.oracle.bmc.datascience.model.ObjectStorageMountConfigurationDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="storageType", defaultImpl=StorageMountConfigurationDetails.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=FileStorageMountConfigurationDetails.class, name="FILE_STORAGE"), @JsonSubTypes.Type(value=ObjectStorageMountConfigurationDetails.class, name="OBJECT_STORAGE")})
@JsonFilter(value="explicitlySetFilter")
public class StorageMountConfigurationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="destinationDirectoryName")
    private final String destinationDirectoryName;
    @JsonProperty(value="destinationPath")
    private final String destinationPath;

    @Deprecated
    @ConstructorProperties(value={"destinationDirectoryName", "destinationPath"})
    protected StorageMountConfigurationDetails(String destinationDirectoryName, String destinationPath) {
        this.destinationDirectoryName = destinationDirectoryName;
        this.destinationPath = destinationPath;
    }

    public String getDestinationDirectoryName() {
        return this.destinationDirectoryName;
    }

    public String getDestinationPath() {
        return this.destinationPath;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StorageMountConfigurationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("destinationDirectoryName=").append(String.valueOf(this.destinationDirectoryName));
        sb.append(", destinationPath=").append(String.valueOf(this.destinationPath));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StorageMountConfigurationDetails)) {
            return false;
        }
        StorageMountConfigurationDetails other = (StorageMountConfigurationDetails)((Object)o);
        return Objects.equals(this.destinationDirectoryName, other.destinationDirectoryName) && Objects.equals(this.destinationPath, other.destinationPath) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.destinationDirectoryName == null ? 43 : this.destinationDirectoryName.hashCode());
        result = result * 59 + (this.destinationPath == null ? 43 : this.destinationPath.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum StorageType implements BmcEnum
    {
        FileStorage("FILE_STORAGE"),
        ObjectStorage("OBJECT_STORAGE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, StorageType> map;

        private StorageType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static StorageType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'StorageType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(StorageType.class);
            map = new HashMap<String, StorageType>();
            for (StorageType v : StorageType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

