/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datascience.model.ChangePipelineRunCompartmentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangePipelineRunCompartmentRequest
extends BmcRequest<ChangePipelineRunCompartmentDetails> {
    private String pipelineRunId;
    private ChangePipelineRunCompartmentDetails changePipelineRunCompartmentDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getPipelineRunId() {
        return this.pipelineRunId;
    }

    public ChangePipelineRunCompartmentDetails getChangePipelineRunCompartmentDetails() {
        return this.changePipelineRunCompartmentDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public ChangePipelineRunCompartmentDetails getBody$() {
        return this.changePipelineRunCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().pipelineRunId(this.pipelineRunId).changePipelineRunCompartmentDetails(this.changePipelineRunCompartmentDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",pipelineRunId=").append(String.valueOf(this.pipelineRunId));
        sb.append(",changePipelineRunCompartmentDetails=").append(String.valueOf((Object)this.changePipelineRunCompartmentDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangePipelineRunCompartmentRequest)) {
            return false;
        }
        ChangePipelineRunCompartmentRequest other = (ChangePipelineRunCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.pipelineRunId, other.pipelineRunId) && Objects.equals((Object)this.changePipelineRunCompartmentDetails, (Object)other.changePipelineRunCompartmentDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pipelineRunId == null ? 43 : this.pipelineRunId.hashCode());
        result = result * 59 + (this.changePipelineRunCompartmentDetails == null ? 43 : this.changePipelineRunCompartmentDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangePipelineRunCompartmentRequest, ChangePipelineRunCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String pipelineRunId = null;
        private ChangePipelineRunCompartmentDetails changePipelineRunCompartmentDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder pipelineRunId(String pipelineRunId) {
            this.pipelineRunId = pipelineRunId;
            return this;
        }

        public Builder changePipelineRunCompartmentDetails(ChangePipelineRunCompartmentDetails changePipelineRunCompartmentDetails) {
            this.changePipelineRunCompartmentDetails = changePipelineRunCompartmentDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangePipelineRunCompartmentRequest o) {
            this.pipelineRunId(o.getPipelineRunId());
            this.changePipelineRunCompartmentDetails(o.getChangePipelineRunCompartmentDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangePipelineRunCompartmentRequest build() {
            ChangePipelineRunCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangePipelineRunCompartmentDetails body) {
            this.changePipelineRunCompartmentDetails(body);
            return this;
        }

        public ChangePipelineRunCompartmentRequest buildWithoutInvocationCallback() {
            ChangePipelineRunCompartmentRequest request = new ChangePipelineRunCompartmentRequest();
            request.pipelineRunId = this.pipelineRunId;
            request.changePipelineRunCompartmentDetails = this.changePipelineRunCompartmentDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

