/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDataSciencePrivateEndpointRequest
extends BmcRequest<Void> {
    private String dataSciencePrivateEndpointId;
    private String opcRequestId;

    public String getDataSciencePrivateEndpointId() {
        return this.dataSciencePrivateEndpointId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().dataSciencePrivateEndpointId(this.dataSciencePrivateEndpointId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dataSciencePrivateEndpointId=").append(String.valueOf(this.dataSciencePrivateEndpointId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDataSciencePrivateEndpointRequest)) {
            return false;
        }
        GetDataSciencePrivateEndpointRequest other = (GetDataSciencePrivateEndpointRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dataSciencePrivateEndpointId, other.dataSciencePrivateEndpointId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dataSciencePrivateEndpointId == null ? 43 : this.dataSciencePrivateEndpointId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDataSciencePrivateEndpointRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dataSciencePrivateEndpointId = null;
        private String opcRequestId = null;

        public Builder dataSciencePrivateEndpointId(String dataSciencePrivateEndpointId) {
            this.dataSciencePrivateEndpointId = dataSciencePrivateEndpointId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDataSciencePrivateEndpointRequest o) {
            this.dataSciencePrivateEndpointId(o.getDataSciencePrivateEndpointId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDataSciencePrivateEndpointRequest build() {
            GetDataSciencePrivateEndpointRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDataSciencePrivateEndpointRequest buildWithoutInvocationCallback() {
            GetDataSciencePrivateEndpointRequest request = new GetDataSciencePrivateEndpointRequest();
            request.dataSciencePrivateEndpointId = this.dataSciencePrivateEndpointId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

