/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.model.Range;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetModelArtifactContentRequest
extends BmcRequest<Void> {
    private String modelId;
    private String opcRequestId;
    private Range range;

    public String getModelId() {
        return this.modelId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Range getRange() {
        return this.range;
    }

    public Builder toBuilder() {
        return new Builder().modelId(this.modelId).opcRequestId(this.opcRequestId).range(this.range);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",modelId=").append(String.valueOf(this.modelId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",range=").append(String.valueOf(this.range));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetModelArtifactContentRequest)) {
            return false;
        }
        GetModelArtifactContentRequest other = (GetModelArtifactContentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.modelId, other.modelId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.range, other.range);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.modelId == null ? 43 : this.modelId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.range == null ? 43 : this.range.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetModelArtifactContentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String modelId = null;
        private String opcRequestId = null;
        private Range range = null;

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder range(Range range) {
            this.range = range;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetModelArtifactContentRequest o) {
            this.modelId(o.getModelId());
            this.opcRequestId(o.getOpcRequestId());
            this.range(o.getRange());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetModelArtifactContentRequest build() {
            GetModelArtifactContentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetModelArtifactContentRequest buildWithoutInvocationCallback() {
            GetModelArtifactContentRequest request = new GetModelArtifactContentRequest();
            request.modelId = this.modelId;
            request.opcRequestId = this.opcRequestId;
            request.range = this.range;
            return request;
        }
    }
}

