/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datascience.model.StorageMountConfigurationDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="storageType")
@JsonFilter(value="explicitlySetFilter")
public final class FileStorageMountConfigurationDetails
extends StorageMountConfigurationDetails {
    @JsonProperty(value="mountTargetId")
    private final String mountTargetId;
    @JsonProperty(value="exportId")
    private final String exportId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public FileStorageMountConfigurationDetails(String destinationDirectoryName, String destinationPath, String mountTargetId, String exportId) {
        super(destinationDirectoryName, destinationPath);
        this.mountTargetId = mountTargetId;
        this.exportId = exportId;
    }

    public String getMountTargetId() {
        return this.mountTargetId;
    }

    public String getExportId() {
        return this.exportId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FileStorageMountConfigurationDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", mountTargetId=").append(String.valueOf(this.mountTargetId));
        sb.append(", exportId=").append(String.valueOf(this.exportId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileStorageMountConfigurationDetails)) {
            return false;
        }
        FileStorageMountConfigurationDetails other = (FileStorageMountConfigurationDetails)((Object)o);
        return Objects.equals(this.mountTargetId, other.mountTargetId) && Objects.equals(this.exportId, other.exportId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.mountTargetId == null ? 43 : this.mountTargetId.hashCode());
        result = result * 59 + (this.exportId == null ? 43 : this.exportId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="destinationDirectoryName")
        private String destinationDirectoryName;
        @JsonProperty(value="destinationPath")
        private String destinationPath;
        @JsonProperty(value="mountTargetId")
        private String mountTargetId;
        @JsonProperty(value="exportId")
        private String exportId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder destinationDirectoryName(String destinationDirectoryName) {
            this.destinationDirectoryName = destinationDirectoryName;
            this.__explicitlySet__.add("destinationDirectoryName");
            return this;
        }

        public Builder destinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
            this.__explicitlySet__.add("destinationPath");
            return this;
        }

        public Builder mountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
            this.__explicitlySet__.add("mountTargetId");
            return this;
        }

        public Builder exportId(String exportId) {
            this.exportId = exportId;
            this.__explicitlySet__.add("exportId");
            return this;
        }

        public FileStorageMountConfigurationDetails build() {
            FileStorageMountConfigurationDetails model = new FileStorageMountConfigurationDetails(this.destinationDirectoryName, this.destinationPath, this.mountTargetId, this.exportId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FileStorageMountConfigurationDetails model) {
            if (model.wasPropertyExplicitlySet("destinationDirectoryName")) {
                this.destinationDirectoryName(model.getDestinationDirectoryName());
            }
            if (model.wasPropertyExplicitlySet("destinationPath")) {
                this.destinationPath(model.getDestinationPath());
            }
            if (model.wasPropertyExplicitlySet("mountTargetId")) {
                this.mountTargetId(model.getMountTargetId());
            }
            if (model.wasPropertyExplicitlySet("exportId")) {
                this.exportId(model.getExportId());
            }
            return this;
        }
    }
}

