/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datascience.model.NotebookSessionShapeConfigDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class NotebookSessionConfigDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="blockStorageSizeInGBs")
    private final Integer blockStorageSizeInGBs;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="privateEndpointId")
    private final String privateEndpointId;
    @JsonProperty(value="notebookSessionShapeConfigDetails")
    private final NotebookSessionShapeConfigDetails notebookSessionShapeConfigDetails;

    @Deprecated
    @ConstructorProperties(value={"shape", "blockStorageSizeInGBs", "subnetId", "privateEndpointId", "notebookSessionShapeConfigDetails"})
    public NotebookSessionConfigDetails(String shape, Integer blockStorageSizeInGBs, String subnetId, String privateEndpointId, NotebookSessionShapeConfigDetails notebookSessionShapeConfigDetails) {
        this.shape = shape;
        this.blockStorageSizeInGBs = blockStorageSizeInGBs;
        this.subnetId = subnetId;
        this.privateEndpointId = privateEndpointId;
        this.notebookSessionShapeConfigDetails = notebookSessionShapeConfigDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getShape() {
        return this.shape;
    }

    public Integer getBlockStorageSizeInGBs() {
        return this.blockStorageSizeInGBs;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getPrivateEndpointId() {
        return this.privateEndpointId;
    }

    public NotebookSessionShapeConfigDetails getNotebookSessionShapeConfigDetails() {
        return this.notebookSessionShapeConfigDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NotebookSessionConfigDetails(");
        sb.append("super=").append(super.toString());
        sb.append("shape=").append(String.valueOf(this.shape));
        sb.append(", blockStorageSizeInGBs=").append(String.valueOf(this.blockStorageSizeInGBs));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", privateEndpointId=").append(String.valueOf(this.privateEndpointId));
        sb.append(", notebookSessionShapeConfigDetails=").append(String.valueOf((Object)this.notebookSessionShapeConfigDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NotebookSessionConfigDetails)) {
            return false;
        }
        NotebookSessionConfigDetails other = (NotebookSessionConfigDetails)((Object)o);
        return Objects.equals(this.shape, other.shape) && Objects.equals(this.blockStorageSizeInGBs, other.blockStorageSizeInGBs) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.privateEndpointId, other.privateEndpointId) && Objects.equals((Object)this.notebookSessionShapeConfigDetails, (Object)other.notebookSessionShapeConfigDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.blockStorageSizeInGBs == null ? 43 : this.blockStorageSizeInGBs.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.privateEndpointId == null ? 43 : this.privateEndpointId.hashCode());
        result = result * 59 + (this.notebookSessionShapeConfigDetails == null ? 43 : this.notebookSessionShapeConfigDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="blockStorageSizeInGBs")
        private Integer blockStorageSizeInGBs;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="privateEndpointId")
        private String privateEndpointId;
        @JsonProperty(value="notebookSessionShapeConfigDetails")
        private NotebookSessionShapeConfigDetails notebookSessionShapeConfigDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder blockStorageSizeInGBs(Integer blockStorageSizeInGBs) {
            this.blockStorageSizeInGBs = blockStorageSizeInGBs;
            this.__explicitlySet__.add("blockStorageSizeInGBs");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder privateEndpointId(String privateEndpointId) {
            this.privateEndpointId = privateEndpointId;
            this.__explicitlySet__.add("privateEndpointId");
            return this;
        }

        public Builder notebookSessionShapeConfigDetails(NotebookSessionShapeConfigDetails notebookSessionShapeConfigDetails) {
            this.notebookSessionShapeConfigDetails = notebookSessionShapeConfigDetails;
            this.__explicitlySet__.add("notebookSessionShapeConfigDetails");
            return this;
        }

        public NotebookSessionConfigDetails build() {
            NotebookSessionConfigDetails model = new NotebookSessionConfigDetails(this.shape, this.blockStorageSizeInGBs, this.subnetId, this.privateEndpointId, this.notebookSessionShapeConfigDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NotebookSessionConfigDetails model) {
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("blockStorageSizeInGBs")) {
                this.blockStorageSizeInGBs(model.getBlockStorageSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("privateEndpointId")) {
                this.privateEndpointId(model.getPrivateEndpointId());
            }
            if (model.wasPropertyExplicitlySet("notebookSessionShapeConfigDetails")) {
                this.notebookSessionShapeConfigDetails(model.getNotebookSessionShapeConfigDetails());
            }
            return this;
        }
    }
}

