/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datascience.model.PipelineStepConfigurationDetails;
import com.oracle.bmc.datascience.model.PipelineStepDetails;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="stepType")
@JsonFilter(value="explicitlySetFilter")
public final class PipelineMLJobStepDetails
extends PipelineStepDetails {
    @JsonProperty(value="jobId")
    private final String jobId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public PipelineMLJobStepDetails(String stepName, String description, List<String> dependsOn, PipelineStepConfigurationDetails stepConfigurationDetails, String jobId) {
        super(stepName, description, dependsOn, stepConfigurationDetails);
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PipelineMLJobStepDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", jobId=").append(String.valueOf(this.jobId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PipelineMLJobStepDetails)) {
            return false;
        }
        PipelineMLJobStepDetails other = (PipelineMLJobStepDetails)((Object)o);
        return Objects.equals(this.jobId, other.jobId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.jobId == null ? 43 : this.jobId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="stepName")
        private String stepName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="dependsOn")
        private List<String> dependsOn;
        @JsonProperty(value="stepConfigurationDetails")
        private PipelineStepConfigurationDetails stepConfigurationDetails;
        @JsonProperty(value="jobId")
        private String jobId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder stepName(String stepName) {
            this.stepName = stepName;
            this.__explicitlySet__.add("stepName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder dependsOn(List<String> dependsOn) {
            this.dependsOn = dependsOn;
            this.__explicitlySet__.add("dependsOn");
            return this;
        }

        public Builder stepConfigurationDetails(PipelineStepConfigurationDetails stepConfigurationDetails) {
            this.stepConfigurationDetails = stepConfigurationDetails;
            this.__explicitlySet__.add("stepConfigurationDetails");
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            this.__explicitlySet__.add("jobId");
            return this;
        }

        public PipelineMLJobStepDetails build() {
            PipelineMLJobStepDetails model = new PipelineMLJobStepDetails(this.stepName, this.description, this.dependsOn, this.stepConfigurationDetails, this.jobId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PipelineMLJobStepDetails model) {
            if (model.wasPropertyExplicitlySet("stepName")) {
                this.stepName(model.getStepName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("dependsOn")) {
                this.dependsOn(model.getDependsOn());
            }
            if (model.wasPropertyExplicitlySet("stepConfigurationDetails")) {
                this.stepConfigurationDetails(model.getStepConfigurationDetails());
            }
            if (model.wasPropertyExplicitlySet("jobId")) {
                this.jobId(model.getJobId());
            }
            return this;
        }
    }
}

