/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datascience.model.CreatePipelineDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreatePipelineRequest
extends BmcRequest<CreatePipelineDetails> {
    private CreatePipelineDetails createPipelineDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public CreatePipelineDetails getCreatePipelineDetails() {
        return this.createPipelineDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreatePipelineDetails getBody$() {
        return this.createPipelineDetails;
    }

    public Builder toBuilder() {
        return new Builder().createPipelineDetails(this.createPipelineDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createPipelineDetails=").append(String.valueOf((Object)this.createPipelineDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreatePipelineRequest)) {
            return false;
        }
        CreatePipelineRequest other = (CreatePipelineRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createPipelineDetails, (Object)other.createPipelineDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createPipelineDetails == null ? 43 : this.createPipelineDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreatePipelineRequest, CreatePipelineDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreatePipelineDetails createPipelineDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder createPipelineDetails(CreatePipelineDetails createPipelineDetails) {
            this.createPipelineDetails = createPipelineDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreatePipelineRequest o) {
            this.createPipelineDetails(o.getCreatePipelineDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreatePipelineRequest build() {
            CreatePipelineRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreatePipelineDetails body) {
            this.createPipelineDetails(body);
            return this;
        }

        public CreatePipelineRequest buildWithoutInvocationCallback() {
            CreatePipelineRequest request = new CreatePipelineRequest();
            request.createPipelineDetails = this.createPipelineDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

