/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.requests.HasContentLength;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.io.InputStream;
import java.util.Objects;

public class CreateStepArtifactRequest
extends BmcRequest<InputStream>
implements HasContentLength {
    private String pipelineId;
    private String stepName;
    private Long contentLength;
    private InputStream stepArtifact;
    private String opcRequestId;
    private String opcRetryToken;
    private String contentDisposition;

    public String getPipelineId() {
        return this.pipelineId;
    }

    public String getStepName() {
        return this.stepName;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public InputStream getStepArtifact() {
        return this.stepArtifact;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    @InternalSdk
    public InputStream getBody$() {
        return this.stepArtifact;
    }

    public Builder toBuilder() {
        return new Builder().pipelineId(this.pipelineId).stepName(this.stepName).contentLength(this.contentLength).stepArtifact(this.stepArtifact).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).contentDisposition(this.contentDisposition);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",pipelineId=").append(String.valueOf(this.pipelineId));
        sb.append(",stepName=").append(String.valueOf(this.stepName));
        sb.append(",contentLength=").append(String.valueOf(this.contentLength));
        sb.append(",stepArtifact=").append(String.valueOf(this.stepArtifact));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",contentDisposition=").append(String.valueOf(this.contentDisposition));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateStepArtifactRequest)) {
            return false;
        }
        CreateStepArtifactRequest other = (CreateStepArtifactRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.pipelineId, other.pipelineId) && Objects.equals(this.stepName, other.stepName) && Objects.equals(this.contentLength, other.contentLength) && Objects.equals(this.stepArtifact, other.stepArtifact) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.contentDisposition, other.contentDisposition);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pipelineId == null ? 43 : this.pipelineId.hashCode());
        result = result * 59 + (this.stepName == null ? 43 : this.stepName.hashCode());
        result = result * 59 + (this.contentLength == null ? 43 : this.contentLength.hashCode());
        result = result * 59 + (this.stepArtifact == null ? 43 : this.stepArtifact.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.contentDisposition == null ? 43 : this.contentDisposition.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateStepArtifactRequest, InputStream> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String pipelineId = null;
        private String stepName = null;
        private Long contentLength = null;
        private InputStream stepArtifact = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String contentDisposition = null;

        public Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public Builder stepArtifact(InputStream stepArtifact) {
            this.stepArtifact = stepArtifact;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateStepArtifactRequest o) {
            this.pipelineId(o.getPipelineId());
            this.stepName(o.getStepName());
            this.contentLength(o.getContentLength());
            this.stepArtifact(o.getStepArtifact());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.contentDisposition(o.getContentDisposition());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateStepArtifactRequest build() {
            CreateStepArtifactRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.stepArtifact(body);
            return this;
        }

        public CreateStepArtifactRequest buildWithoutInvocationCallback() {
            CreateStepArtifactRequest request = new CreateStepArtifactRequest();
            request.pipelineId = this.pipelineId;
            request.stepName = this.stepName;
            request.contentLength = this.contentLength;
            request.stepArtifact = this.stepArtifact;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.contentDisposition = this.contentDisposition;
            return request;
        }
    }
}

