/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteDataSciencePrivateEndpointRequest
extends BmcRequest<Void> {
    private String dataSciencePrivateEndpointId;
    private String opcRequestId;
    private String ifMatch;

    public String getDataSciencePrivateEndpointId() {
        return this.dataSciencePrivateEndpointId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().dataSciencePrivateEndpointId(this.dataSciencePrivateEndpointId).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dataSciencePrivateEndpointId=").append(String.valueOf(this.dataSciencePrivateEndpointId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteDataSciencePrivateEndpointRequest)) {
            return false;
        }
        DeleteDataSciencePrivateEndpointRequest other = (DeleteDataSciencePrivateEndpointRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dataSciencePrivateEndpointId, other.dataSciencePrivateEndpointId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dataSciencePrivateEndpointId == null ? 43 : this.dataSciencePrivateEndpointId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteDataSciencePrivateEndpointRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dataSciencePrivateEndpointId = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder dataSciencePrivateEndpointId(String dataSciencePrivateEndpointId) {
            this.dataSciencePrivateEndpointId = dataSciencePrivateEndpointId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDataSciencePrivateEndpointRequest o) {
            this.dataSciencePrivateEndpointId(o.getDataSciencePrivateEndpointId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDataSciencePrivateEndpointRequest build() {
            DeleteDataSciencePrivateEndpointRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteDataSciencePrivateEndpointRequest buildWithoutInvocationCallback() {
            DeleteDataSciencePrivateEndpointRequest request = new DeleteDataSciencePrivateEndpointRequest();
            request.dataSciencePrivateEndpointId = this.dataSciencePrivateEndpointId;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

