/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteJobRequest
extends BmcRequest<Void> {
    private String jobId;
    private String ifMatch;
    private String opcRequestId;
    private Boolean deleteRelatedJobRuns;

    public String getJobId() {
        return this.jobId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getDeleteRelatedJobRuns() {
        return this.deleteRelatedJobRuns;
    }

    public Builder toBuilder() {
        return new Builder().jobId(this.jobId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).deleteRelatedJobRuns(this.deleteRelatedJobRuns);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",jobId=").append(String.valueOf(this.jobId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",deleteRelatedJobRuns=").append(String.valueOf(this.deleteRelatedJobRuns));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteJobRequest)) {
            return false;
        }
        DeleteJobRequest other = (DeleteJobRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.jobId, other.jobId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.deleteRelatedJobRuns, other.deleteRelatedJobRuns);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.jobId == null ? 43 : this.jobId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.deleteRelatedJobRuns == null ? 43 : this.deleteRelatedJobRuns.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteJobRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String jobId = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private Boolean deleteRelatedJobRuns = null;

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder deleteRelatedJobRuns(Boolean deleteRelatedJobRuns) {
            this.deleteRelatedJobRuns = deleteRelatedJobRuns;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteJobRequest o) {
            this.jobId(o.getJobId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.deleteRelatedJobRuns(o.getDeleteRelatedJobRuns());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteJobRequest build() {
            DeleteJobRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteJobRequest buildWithoutInvocationCallback() {
            DeleteJobRequest request = new DeleteJobRequest();
            request.jobId = this.jobId;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.deleteRelatedJobRuns = this.deleteRelatedJobRuns;
            return request;
        }
    }
}

