/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeletePipelineRequest
extends BmcRequest<Void> {
    private String pipelineId;
    private Boolean deleteRelatedPipelineRuns;
    private Boolean deleteRelatedJobRuns;
    private String ifMatch;
    private String opcRequestId;

    public String getPipelineId() {
        return this.pipelineId;
    }

    public Boolean getDeleteRelatedPipelineRuns() {
        return this.deleteRelatedPipelineRuns;
    }

    public Boolean getDeleteRelatedJobRuns() {
        return this.deleteRelatedJobRuns;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().pipelineId(this.pipelineId).deleteRelatedPipelineRuns(this.deleteRelatedPipelineRuns).deleteRelatedJobRuns(this.deleteRelatedJobRuns).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",pipelineId=").append(String.valueOf(this.pipelineId));
        sb.append(",deleteRelatedPipelineRuns=").append(String.valueOf(this.deleteRelatedPipelineRuns));
        sb.append(",deleteRelatedJobRuns=").append(String.valueOf(this.deleteRelatedJobRuns));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeletePipelineRequest)) {
            return false;
        }
        DeletePipelineRequest other = (DeletePipelineRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.pipelineId, other.pipelineId) && Objects.equals(this.deleteRelatedPipelineRuns, other.deleteRelatedPipelineRuns) && Objects.equals(this.deleteRelatedJobRuns, other.deleteRelatedJobRuns) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pipelineId == null ? 43 : this.pipelineId.hashCode());
        result = result * 59 + (this.deleteRelatedPipelineRuns == null ? 43 : this.deleteRelatedPipelineRuns.hashCode());
        result = result * 59 + (this.deleteRelatedJobRuns == null ? 43 : this.deleteRelatedJobRuns.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeletePipelineRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String pipelineId = null;
        private Boolean deleteRelatedPipelineRuns = null;
        private Boolean deleteRelatedJobRuns = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public Builder deleteRelatedPipelineRuns(Boolean deleteRelatedPipelineRuns) {
            this.deleteRelatedPipelineRuns = deleteRelatedPipelineRuns;
            return this;
        }

        public Builder deleteRelatedJobRuns(Boolean deleteRelatedJobRuns) {
            this.deleteRelatedJobRuns = deleteRelatedJobRuns;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeletePipelineRequest o) {
            this.pipelineId(o.getPipelineId());
            this.deleteRelatedPipelineRuns(o.getDeleteRelatedPipelineRuns());
            this.deleteRelatedJobRuns(o.getDeleteRelatedJobRuns());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeletePipelineRequest build() {
            DeletePipelineRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeletePipelineRequest buildWithoutInvocationCallback() {
            DeletePipelineRequest request = new DeletePipelineRequest();
            request.pipelineId = this.pipelineId;
            request.deleteRelatedPipelineRuns = this.deleteRelatedPipelineRuns;
            request.deleteRelatedJobRuns = this.deleteRelatedJobRuns;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

