/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class HeadStepArtifactRequest
extends BmcRequest<Void> {
    private String pipelineId;
    private String stepName;
    private String opcRequestId;

    public String getPipelineId() {
        return this.pipelineId;
    }

    public String getStepName() {
        return this.stepName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().pipelineId(this.pipelineId).stepName(this.stepName).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",pipelineId=").append(String.valueOf(this.pipelineId));
        sb.append(",stepName=").append(String.valueOf(this.stepName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HeadStepArtifactRequest)) {
            return false;
        }
        HeadStepArtifactRequest other = (HeadStepArtifactRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.pipelineId, other.pipelineId) && Objects.equals(this.stepName, other.stepName) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pipelineId == null ? 43 : this.pipelineId.hashCode());
        result = result * 59 + (this.stepName == null ? 43 : this.stepName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<HeadStepArtifactRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String pipelineId = null;
        private String stepName = null;
        private String opcRequestId = null;

        public Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(HeadStepArtifactRequest o) {
            this.pipelineId(o.getPipelineId());
            this.stepName(o.getStepName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public HeadStepArtifactRequest build() {
            HeadStepArtifactRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public HeadStepArtifactRequest buildWithoutInvocationCallback() {
            HeadStepArtifactRequest request = new HeadStepArtifactRequest();
            request.pipelineId = this.pipelineId;
            request.stepName = this.stepName;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

