/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datascience.model.ArtifactImportDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="artifactSourceType")
@JsonFilter(value="explicitlySetFilter")
public final class ArtifactImportDetailsObjectStorage
extends ArtifactImportDetails {
    @JsonProperty(value="namespace")
    private final String namespace;
    @JsonProperty(value="destinationBucket")
    private final String destinationBucket;
    @JsonProperty(value="destinationObjectName")
    private final String destinationObjectName;
    @JsonProperty(value="destinationRegion")
    private final String destinationRegion;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ArtifactImportDetailsObjectStorage(String namespace, String destinationBucket, String destinationObjectName, String destinationRegion) {
        this.namespace = namespace;
        this.destinationBucket = destinationBucket;
        this.destinationObjectName = destinationObjectName;
        this.destinationRegion = destinationRegion;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getDestinationBucket() {
        return this.destinationBucket;
    }

    public String getDestinationObjectName() {
        return this.destinationObjectName;
    }

    public String getDestinationRegion() {
        return this.destinationRegion;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ArtifactImportDetailsObjectStorage(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", namespace=").append(String.valueOf(this.namespace));
        sb.append(", destinationBucket=").append(String.valueOf(this.destinationBucket));
        sb.append(", destinationObjectName=").append(String.valueOf(this.destinationObjectName));
        sb.append(", destinationRegion=").append(String.valueOf(this.destinationRegion));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArtifactImportDetailsObjectStorage)) {
            return false;
        }
        ArtifactImportDetailsObjectStorage other = (ArtifactImportDetailsObjectStorage)((Object)o);
        return Objects.equals(this.namespace, other.namespace) && Objects.equals(this.destinationBucket, other.destinationBucket) && Objects.equals(this.destinationObjectName, other.destinationObjectName) && Objects.equals(this.destinationRegion, other.destinationRegion) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.destinationBucket == null ? 43 : this.destinationBucket.hashCode());
        result = result * 59 + (this.destinationObjectName == null ? 43 : this.destinationObjectName.hashCode());
        result = result * 59 + (this.destinationRegion == null ? 43 : this.destinationRegion.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="namespace")
        private String namespace;
        @JsonProperty(value="destinationBucket")
        private String destinationBucket;
        @JsonProperty(value="destinationObjectName")
        private String destinationObjectName;
        @JsonProperty(value="destinationRegion")
        private String destinationRegion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder destinationBucket(String destinationBucket) {
            this.destinationBucket = destinationBucket;
            this.__explicitlySet__.add("destinationBucket");
            return this;
        }

        public Builder destinationObjectName(String destinationObjectName) {
            this.destinationObjectName = destinationObjectName;
            this.__explicitlySet__.add("destinationObjectName");
            return this;
        }

        public Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            this.__explicitlySet__.add("destinationRegion");
            return this;
        }

        public ArtifactImportDetailsObjectStorage build() {
            ArtifactImportDetailsObjectStorage model = new ArtifactImportDetailsObjectStorage(this.namespace, this.destinationBucket, this.destinationObjectName, this.destinationRegion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ArtifactImportDetailsObjectStorage model) {
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("destinationBucket")) {
                this.destinationBucket(model.getDestinationBucket());
            }
            if (model.wasPropertyExplicitlySet("destinationObjectName")) {
                this.destinationObjectName(model.getDestinationObjectName());
            }
            if (model.wasPropertyExplicitlySet("destinationRegion")) {
                this.destinationRegion(model.getDestinationRegion());
            }
            return this;
        }
    }
}

