/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datascience.model.AutoScalingPolicyDetails;
import com.oracle.bmc.datascience.model.ScalingPolicy;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="policyType")
@JsonFilter(value="explicitlySetFilter")
public final class AutoScalingPolicy
extends ScalingPolicy {
    @JsonProperty(value="coolDownInSeconds")
    private final Integer coolDownInSeconds;
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="autoScalingPolicies")
    private final List<AutoScalingPolicyDetails> autoScalingPolicies;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public AutoScalingPolicy(Integer coolDownInSeconds, Boolean isEnabled, List<AutoScalingPolicyDetails> autoScalingPolicies) {
        this.coolDownInSeconds = coolDownInSeconds;
        this.isEnabled = isEnabled;
        this.autoScalingPolicies = autoScalingPolicies;
    }

    public Integer getCoolDownInSeconds() {
        return this.coolDownInSeconds;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public List<AutoScalingPolicyDetails> getAutoScalingPolicies() {
        return this.autoScalingPolicies;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutoScalingPolicy(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", coolDownInSeconds=").append(String.valueOf(this.coolDownInSeconds));
        sb.append(", isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", autoScalingPolicies=").append(String.valueOf(this.autoScalingPolicies));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutoScalingPolicy)) {
            return false;
        }
        AutoScalingPolicy other = (AutoScalingPolicy)((Object)o);
        return Objects.equals(this.coolDownInSeconds, other.coolDownInSeconds) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals(this.autoScalingPolicies, other.autoScalingPolicies) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.coolDownInSeconds == null ? 43 : this.coolDownInSeconds.hashCode());
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.autoScalingPolicies == null ? 43 : this.autoScalingPolicies.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="coolDownInSeconds")
        private Integer coolDownInSeconds;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="autoScalingPolicies")
        private List<AutoScalingPolicyDetails> autoScalingPolicies;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder coolDownInSeconds(Integer coolDownInSeconds) {
            this.coolDownInSeconds = coolDownInSeconds;
            this.__explicitlySet__.add("coolDownInSeconds");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder autoScalingPolicies(List<AutoScalingPolicyDetails> autoScalingPolicies) {
            this.autoScalingPolicies = autoScalingPolicies;
            this.__explicitlySet__.add("autoScalingPolicies");
            return this;
        }

        public AutoScalingPolicy build() {
            AutoScalingPolicy model = new AutoScalingPolicy(this.coolDownInSeconds, this.isEnabled, this.autoScalingPolicies);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutoScalingPolicy model) {
            if (model.wasPropertyExplicitlySet("coolDownInSeconds")) {
                this.coolDownInSeconds(model.getCoolDownInSeconds());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("autoScalingPolicies")) {
                this.autoScalingPolicies(model.getAutoScalingPolicies());
            }
            return this;
        }
    }
}

