/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datascience.model.PipelineConfigurationDetails;
import com.oracle.bmc.datascience.model.PipelineLogConfigurationDetails;
import com.oracle.bmc.datascience.model.PipelineStepOverrideDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreatePipelineRunDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="projectId")
    private final String projectId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="pipelineId")
    private final String pipelineId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="configurationOverrideDetails")
    private final PipelineConfigurationDetails configurationOverrideDetails;
    @JsonProperty(value="logConfigurationOverrideDetails")
    private final PipelineLogConfigurationDetails logConfigurationOverrideDetails;
    @JsonProperty(value="stepOverrideDetails")
    private final List<PipelineStepOverrideDetails> stepOverrideDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"projectId", "compartmentId", "pipelineId", "displayName", "configurationOverrideDetails", "logConfigurationOverrideDetails", "stepOverrideDetails", "freeformTags", "definedTags", "systemTags"})
    public CreatePipelineRunDetails(String projectId, String compartmentId, String pipelineId, String displayName, PipelineConfigurationDetails configurationOverrideDetails, PipelineLogConfigurationDetails logConfigurationOverrideDetails, List<PipelineStepOverrideDetails> stepOverrideDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.projectId = projectId;
        this.compartmentId = compartmentId;
        this.pipelineId = pipelineId;
        this.displayName = displayName;
        this.configurationOverrideDetails = configurationOverrideDetails;
        this.logConfigurationOverrideDetails = logConfigurationOverrideDetails;
        this.stepOverrideDetails = stepOverrideDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public PipelineConfigurationDetails getConfigurationOverrideDetails() {
        return this.configurationOverrideDetails;
    }

    public PipelineLogConfigurationDetails getLogConfigurationOverrideDetails() {
        return this.logConfigurationOverrideDetails;
    }

    public List<PipelineStepOverrideDetails> getStepOverrideDetails() {
        return this.stepOverrideDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreatePipelineRunDetails(");
        sb.append("super=").append(super.toString());
        sb.append("projectId=").append(String.valueOf(this.projectId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", pipelineId=").append(String.valueOf(this.pipelineId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", configurationOverrideDetails=").append(String.valueOf((Object)this.configurationOverrideDetails));
        sb.append(", logConfigurationOverrideDetails=").append(String.valueOf((Object)this.logConfigurationOverrideDetails));
        sb.append(", stepOverrideDetails=").append(String.valueOf(this.stepOverrideDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreatePipelineRunDetails)) {
            return false;
        }
        CreatePipelineRunDetails other = (CreatePipelineRunDetails)((Object)o);
        return Objects.equals(this.projectId, other.projectId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.pipelineId, other.pipelineId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.configurationOverrideDetails, (Object)other.configurationOverrideDetails) && Objects.equals((Object)this.logConfigurationOverrideDetails, (Object)other.logConfigurationOverrideDetails) && Objects.equals(this.stepOverrideDetails, other.stepOverrideDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.projectId == null ? 43 : this.projectId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.pipelineId == null ? 43 : this.pipelineId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.configurationOverrideDetails == null ? 43 : this.configurationOverrideDetails.hashCode());
        result = result * 59 + (this.logConfigurationOverrideDetails == null ? 43 : this.logConfigurationOverrideDetails.hashCode());
        result = result * 59 + (this.stepOverrideDetails == null ? 43 : this.stepOverrideDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="projectId")
        private String projectId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="pipelineId")
        private String pipelineId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="configurationOverrideDetails")
        private PipelineConfigurationDetails configurationOverrideDetails;
        @JsonProperty(value="logConfigurationOverrideDetails")
        private PipelineLogConfigurationDetails logConfigurationOverrideDetails;
        @JsonProperty(value="stepOverrideDetails")
        private List<PipelineStepOverrideDetails> stepOverrideDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            this.__explicitlySet__.add("projectId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            this.__explicitlySet__.add("pipelineId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder configurationOverrideDetails(PipelineConfigurationDetails configurationOverrideDetails) {
            this.configurationOverrideDetails = configurationOverrideDetails;
            this.__explicitlySet__.add("configurationOverrideDetails");
            return this;
        }

        public Builder logConfigurationOverrideDetails(PipelineLogConfigurationDetails logConfigurationOverrideDetails) {
            this.logConfigurationOverrideDetails = logConfigurationOverrideDetails;
            this.__explicitlySet__.add("logConfigurationOverrideDetails");
            return this;
        }

        public Builder stepOverrideDetails(List<PipelineStepOverrideDetails> stepOverrideDetails) {
            this.stepOverrideDetails = stepOverrideDetails;
            this.__explicitlySet__.add("stepOverrideDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public CreatePipelineRunDetails build() {
            CreatePipelineRunDetails model = new CreatePipelineRunDetails(this.projectId, this.compartmentId, this.pipelineId, this.displayName, this.configurationOverrideDetails, this.logConfigurationOverrideDetails, this.stepOverrideDetails, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreatePipelineRunDetails model) {
            if (model.wasPropertyExplicitlySet("projectId")) {
                this.projectId(model.getProjectId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("pipelineId")) {
                this.pipelineId(model.getPipelineId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("configurationOverrideDetails")) {
                this.configurationOverrideDetails(model.getConfigurationOverrideDetails());
            }
            if (model.wasPropertyExplicitlySet("logConfigurationOverrideDetails")) {
                this.logConfigurationOverrideDetails(model.getLogConfigurationOverrideDetails());
            }
            if (model.wasPropertyExplicitlySet("stepOverrideDetails")) {
                this.stepOverrideDetails(model.getStepOverrideDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

